from kazoo.client import KazooClient
import socket


class ZK(object):

    _prefix = '/conductor/agent/lock/'

    def __init__(self, ctx, hosts):
        self.semaphores = {}
        self.log = ctx.log.getChild('ZK')

        self.zk = KazooClient(hosts=','.join(hosts))
        self.hostname = socket.gethostname()
        self.zk.start()

    def lock(self, task_id, leases):
        if not task_id in self.semaphores:
            lockname = self._prefix + str(task_id)
            self.semaphores[task_id] = self.zk.Semaphore(lockname, self.hostname, max_leases=leases)
            self.log.debug("Acquiring the lock for %s", task_id)
            self.semaphores[task_id].acquire()
            self.log.debug("Lock for %s acquired", task_id)

    def unlock(self, task_id):
        if task_id in self.semaphores:
            self.semaphores[task_id].release()
            del self.semaphores[task_id]
            self.log.debug("Lock for %s released", task_id)
            try:
                lockname = self._prefix + str(task_id)
                self.zk.delete(lockname + '-__lock__')
                self.zk.delete(lockname)
            except:
                pass
