# Базовые роли пользователей

Для ограничения доступа пользователей к объектам {{ serviceName }}а используются роли:

- _Passerby_, <q>Прохожий</q>. Роль предназначена для пользователей, чьи задачи ограничены созданием [тикетов](./task/tickets.md) на выкладку определенных пакетов. {#passerby}
- _Audience_, <q>Зритель</q>. Роль предназначена для пользователей, работающих с ограниченным перечнем [проектов](./task/projects.md#projects). В задачи Audience-пользователя входит: {#audience}
    
    - внесение изменений в основные [свойства пакетов](./task/packages.md);
    - создание [тикетов на выкладку](./task/tickets.md);
    - контроль установки пакетов.

- _Musician_, <q>Музыкант</q>. В задачи таких пользователей входит: {#musician}
    
    - создание [проектов](./task/projects.md#new);
    - изменение [свойства пакетов](./task/packages.md);
    - обеспечение выкладки.

- _Soloist_, <q>Солист</q>. В задачи таких пользователей входит: {#soloist}
    
    - создание [проектов](./task/projects.md#new);
    - изменение [свойства пакетов](./task/packages.md);
    - управление [датацентрами](./task/datacenters.md) и [репозиториями](./task/repos.md);
    - обеспечение выкладки.

- _Conductor_, <q>Дирижер</q>. Роль супрепользователя в рамках кондуктора. Роль предназначена для пользователей, обслуживающих кондуктор. В задачи таких пользователей входит: {#conductor}
    
    - поддержание работоспособности сервиса;
    - редактирование генераторов API;
    - управление всеми проектами;
    - [управление доступом](./task/roles.md#roles) пользователей с ролью Passerby.

Роли приведены в порядке увеличения прав доступа. Права наследуются, то есть старшая роль обладает всеми правами младшей.

По умолчанию все пользователи обладают ролью Passerby. Чтобы получить другую роль, [запросите](./task/admin-role.md#admin-role) ее в IDM.

## Права доступа

Все пользователи {{ serviceName }}а, кроме пользователей с ролью Passerby, обладают рядом общих прав:

- Просматривать все [объекты](package-props.md#package-props){{ serviceName }}а.
    
- [Создавать](./task/packages.md#new), [изменять](./task/packages.md#edit) и [удалять](./task/packages.md#DeletePackage) пакеты.
    
- Создавать [тикеты](./task/tickets.md) на выкладку, редактировать созданные тикеты и отзывать их.
    
- Обладать одной из [проектных ролей:](./task/project-roles.md)
    
    - [администратор проекта](./task/project-roles.md#project-admin);
    - [администратор группы хостов](./task/project-roles.md#group-admin);
    - [одобрятор](./task/project-roles.md#approver).

- Объединять воркфлоу своих проектов в [группы](./task/workflow_groups.md) или добавлять их к уже существующим.

Права Passerby-пользователей ограничены созданием тикетов на выкладку на некоторые хосты. Перечень доступных хостов определяет Conductor (см. раздел <q>[Настройка доступа для Passerby](./task/roles.md#roles)</q>).

Права пользователя по отношению к объектам, для которых он **не является** администратором, зависят от его роли. Описание прав приведено в таблице:

#|
||  **Объекты в {{ serviceName }}е** |  | **Passerby** | **Audience** | **Musician** | **Soloist** | **Conductor** ||
||  Пакеты | создание |  | ✔ | ✔ | ✔ | ✔ ||
||  | изменение | - | ✔ | ✔ | ✔ | ✔ ||
||  | удаление | - | ✔ | ✔ | ✔ | ✔ ||
||  Тикеты | создание | - | - | - | - | ✔ ||
||  | изменение | - | ✔ | ✔ | ✔ | ✔ ||
||  | удаление | - | - | - | - | ✔ ||
||  Таски | создание | - | - | - | - | ✔ ||
||  | изменение | - | - | - | - | ✔ ||
||  | удаление | - | - | - | - | ✔ ||
||  Проекты | создание | - | - | ✔ | ✔ | ✔ ||
||  | изменение | - | - | - | - | ✔ ||
||  | удаление | - | - | - | - | ✔ ||
||  Генераторы API | создание | - | - | - | - | ✔ ||
||  | изменение | - | - | - | - | ✔ ||
||  | удаление | - | - | - | - | ✔ ||
||  Хосты | создание | - | - | - | - | ✔ ||
||  | изменение | - | - | - | - | ✔ ||
||  | удаление | - | - | - | - | ✔ ||
||  Группы | создание | - | - | - | - | ✔ ||
||  | изменение | - | - | - | - | ✔ ||
||  | удаление | - | - | - | - | ✔ ||
||  Макросы | создание | - | - | ✔ | ✔ | ✔ ||
||  | изменение | - | - | ✔ | ✔ | ✔ ||
||  | удаление | - | - | ✔ | ✔ | ✔ ||
||  Воркфлоу | создание | - | - | - | - | ✔ ||
||  | изменение | - | - | - | - | ✔ ||
||  | удаление | - | - | - | - | ✔ ||
||  Группы воркфлоу | создание | - | - | - | - | ✔ ||
||  | изменение | - | ✔ | ✔ | ✔ | ✔ ||
||  | удаление | - | - | - | - | ✔ ||
||  Сервисы | создание | - | - | ✔ | ✔ | ✔ ||
||  | изменение | - | - | ✔ | ✔ | ✔ ||
||  | удаление | - | - | ✔ | ✔ | ✔ ||
||  Датацентры | создание | - | - | - | ✔ | ✔ ||
||  | изменение | - | - | - | ✔ | ✔ ||
||  | удаление | - | - | - | ✔ | ✔ ||
||  Репозитории | создание | - | - | - | ✔ | ✔ ||
||  | изменение | - | - | - | ✔ | ✔ ||
||  | удаление | - | - | - | ✔ | ✔ ||
||  Тесты | создание | - | ✔ | ✔ | ✔ | ✔ ||
||  | изменение | - | ✔ | ✔ | ✔ | ✔ ||
||  | удаление | - | ✔ | ✔ | ✔ | ✔ ||
||  Вебхуки | создание | - | ✔ | ✔ | ✔ | ✔ ||
||  | изменение | - | ✔ | ✔ | ✔ | ✔ ||
||  | удаление | - | ✔ | ✔ | ✔ | ✔ ||
||  Пользователи | создание | - | - | - | - | - ||
||  | изменение | - | - | - | - | ✔ ||
||  | удаление | - | - | - | - | - ||
||  Роли | создание | - | - | - | - | ✔ ||
||  | изменение | - | - | - | - | ✔ ||
||  | удаление | - | - | - | - | ✔ ||
|#
