# Ветки

В [тикете на выкладку](./task/tickets.md) определяется название, версия и _ветка_, в которую должен быть выложен пакет.

В большинстве репозиториев выкладка выполняется в одну из [стандартных веток](#standard-branches). В некоторых проектах в качестве веток могут использоваться нестандартные сущности, например, названия дистрибутивов.

Порядок движения пакета по веткам определяется ответственными разработчиками и менеджерами. Наиболее распространенным является следующий:

1. [testing](#testing);
1. [prestable](#prestable), если определен;
1. [stable](#stable).

Пакет также может быть выложен в одну из внерегламентных веток, фактически указывающих на [stable](#stable), но предполагающих определенные изменения в порядке выкладки — [hotfix](#hotfix) и [fallback](#fallback).

Описание стандартных веток представлено в таблице:

#|
|| **Ветка** | **Тип целевого сервера** | **Описание** ||
|| **unstable** | Тестовый. | Окружение для разработки. ||
|| **testing** {#testing} | Тестовый. | Тестовое окружение.

По умолчанию данная ветка является обязательной (т.е. перед выкладкой в любую другую необходимо выложить пакет в testing).

В большинстве случаев свойства пакета не допускают выкладку пакета в [stable](#stable) без предварительной выкладки в testing.

В некоторых случаях (например, при создании нескольких макетов одного и того же объекта для выбора подходящего) выкладка пакета может ограничиваться данной веткой.

В зависимости от [настроек воркфлоу](./task/workflows.md) может выполняться автоматически или [администратором](access.md) ||
|| **prestable** {#prestable} | Тестовый. | Окружение, приближенное к боевому.

По умолчанию выкладка в данную ветку является необязательной.

Возможными (но не единственными) различиями между [testing](#testing) и prestable могут быть:

- Нагрузка.
    
    Prestable может храниться на сервере, находящимся под нагрузкой.

- Тип данных.
    
    Prestable может использовать данные с боевых серверов, в то время как [testing](#testing) — тестовые. В частности, по этой причине в prestable иногда невозможно протестировать запись данных.

- Взаимодействие с разными сервисами.
    
    В ряде случаев prestable и [testing](#testing) являются одними и теми же средами, в которых хранятся разные части одного и того же сервиса. Ветка [testing](#testing) может являться тестовой средой непосредственно для самого сервиса, а для других сервисов использоваться в качестве prestable.

{% include [branches-WhoDeploys](./_includes/concepts/branches/id-branches/WhoDeploys.md) %} ||
|| **stable** {#stable} | Production. | Боевые серверы и окружение.

{% include [branches-WhoDeploys](./_includes/concepts/branches/id-branches/WhoDeploys.md) %} ||
|| **hotfix** {#hotfix} | Production. | Боевые серверы и окружение.

Используется для срочной выкладки в обход веток [testing](#testing) и/или [prestable](#prestable) (даже если данное требование указано в [свойствах пакета)](./task/packages.md). ||
|| **fallback** {#fallback} | Production. | Боевые серверы и окружение.

Используется для явного указания на откат пакета.

В большинстве случаев [администраторы](access.md) отклоняют заявки на выкладку пакета предыдущей версии в [stable](#stable), предполагая, что это ошибка. Выкладка в fallback указывает на осознанность действия.

Выполняется [администратором](access.md) (автоадмин не используется). ||
|#
