# Статусы тикетов и тасков

После [регистрации тикета на выкладку](./task/tickets.md) и [формирования тасков](./task/tickets.md#tickets) инициируется выкладка пакетов. Таски, в которых корректно настроены [пакеты](./task/packages.md) и [объекты, влияющие на выкладку](package-props.md), принимаются к исполнению.

Для контроля выкладки используются статусы — характеристики тикетов и тасков, отражающие ход выкладки входящих в них пакетов. Отслеживание статусов позволяет своевременно реагировать на возможные проблемы с выкладкой.

Список статусов тикетов и тасков приведен в таблице.

#|
|| **Статус** | **Распространение** | **Описание** ||
|| **new** {#new} | Тикеты, таски | Присваивается при [создании](./task/tickets.md) тикета.

В данном статусе тикет может быть отредактирован или отозван.

Включает некоторые служебные состояния, не отображаемые в интерфейсе, при которых остановить или отредактировать таски невозможно. Это означает, что полезных действий по пакету предпринято еще не было, но уже произошли некоторые изменения. Например, в случае, если автоматика начала предпринимать действия по выкладке пакета, но при этом возникли ошибки, может сохраниться статус <q>new</q>. ||
|| **in_work** {#inprogress} | Тикеты | Все подчиненные таски выполняются или находятся в разных статусах. ||
|| **deploying** | Таски | Пакеты устанавливаются с помощью [утилиты](utilities.md) `conductor-agent`. ||
|| **frozen** | Таски | Пакет не может быть корректно выложен автоадмином. Например, возникли ошибки с зависимостями, конфликты и пр.

Дальнейшая установка пакета возможна только вручную администратором. ||
|| **done** {#done} | Тикеты, таски | Возможные значения:

- Для _тасков_: выкладка пакета выполнена. Если назначены тесты — их выполнение закончено.
- Для _тикетов_: выкладка пакетов всех тасков выполнена.

{% note info %}

[Уведомления](notifications.md#notifications) о статусе <q>done</q> отправляются перед постановкой тикета на тестирование в очередь, если в свойствах пакета определены тесты.

{% endnote %} ||
|| **need_info** | Тикеты | Тикет не может быть принят к исполнению.

{% include [statuses-EditDelTicket](./_includes/concepts/statuses/id-statuses/EditDelTicket.md) %}

Возможная причина — некорректная [настройка свойств пакета](./task/packages.md#edit) (например, не определены [хосты](./task/hosts.md#new) или [группы хостов](./task/groups.md#new), не может быть установлена связь с [проектами](./task/projects.md#new)).

Иногда ошибки возникают при попытке выложить новый пакет. После автоматического добавления пакета из `dist.yandex.ru` большинство свойств не определены. Для успешной выкладки пакета необходимо предварительно выполнить [настройку свойств](./task/packages.md#edit). ||
|| **maybe_missing** {#maybemissing} | Тикеты | По крайней мере один из пакетов, указанных в тикете на выкладку, не может быть найден в указанных репозиториях.

{% include [statuses-EditDelTicket](./_includes/concepts/statuses/id-statuses/EditDelTicket.md) %}

{{ serviceName }} регулярно опрашивает [зарегистрированные](./task/repos.md) [репозитории](package-props.md#Repos) и определяет версии загруженных пакетов. Если ни в одном репозитории не найден пакет той версии, которая указана в тикете, попытка выкладки не предпринимается и выставляется данный статус.

Сохраняется в течение 15 минут. В это время {{ serviceName }} продолжает поиск пакетов требуемой версии.

Если в течение 15 минут требуемая версия не найдена, тикет переводится в статус [missing](#missing). ||
|| **missing** {#missing} | Тикеты | Выставляется через 15 минут после перевода тикета в [maybe missing](#maybemissing), если {{ serviceName }} не находит указанные пакеты и/или их версии. Наиболее вероятно, что возникла нештатная ситуация при загрузке пакета в репозиторий. Автору тикета отправляется [уведомление](notifications.md).

{% include [statuses-EditDelTicket](./_includes/concepts/statuses/id-statuses/EditDelTicket.md) %} ||
|| **obsolete** | {% include [statuses-tickettask](./_includes/concepts/statuses/id-statuses/tickettask.md) %} | Выставляется, если параллельно с выполнением тикета/таска хотя бы для одного выкладываемого пакета создан и успешн завершен (статус [done](#done)) другой (более свежий) тикет/таск.

Версии пакета в тикетах/тасках могут различаться. ||
|#

В зависимости от [утилиты](utilities.md), используемой для выкладки пакета, статусы тикетов и тасков выставляются в соответствии с правилами, описанными в таблице ниже.

Утилита | Статус таска | Статус тикета
:--- | :--- | :---
`executer` | Совпадает | Соответствует статусу таска
`executer` | Различается | [in_work](#inprogress)
`conductor-agent` | Совпадает, но отличается от [dmoving](#dmoving-desc) | Соответствует статусу таска
`conductor-agent` | Совпадает и соответствует [dmoving](#dmoving-desc) | [new](#new)
`conductor-agent` | Различается | [in_work](#inprogress)

## Служебные статусы {#IntStatuses}

В процессе выкладки пакета ([in work](#inprogress) и [new](#new)) таск может находиться в одном из служебных статусов, которые доступны только администраторам. Эти статусы позволяют определить, на каком этапе возникла ошибка, в случае нештатных ситуаций.

Список служебных статусов в порядке их присвоения во время выкладки приведен в таблице.

Статус | Описание
:--- | :---
**waiting_for_dmove** | Пакет ожидает автоматического `dmove` (выполняется по cron). Выставляется только для пакетов, выкладываемых с помощью [{{ conductor-agent }}](utilities.md).
**auto_dmoving** | Пакет перемещается в нужную ветку с помощью команды `dmove` (взаимодействие с dist в автоматическом режиме). Выставляется только для пакетов, выкладываемых с помощью [{{ conductor-agent }}](utilities.md).<br/><br/>Вне зависимости от результата после попытки перемещения таск переводится в статус [new](#new).
**dmoving** {#dmoving-desc} | Пакет перемещается между [ветками](branches.md#branches) [репозитория](package-props.md#Repos). Выставляется только для тасков, выполняемых с помощью автоадмина (предоставляется утилитой [{{ executor }}](utilities.md)).
**dmoved** | Пакет перемещен в требуемую ветку.
**preinstalling** | [Сервисы](package-props.md#Services), которые необходимо [перезапустить до выкладки](./task/packages.md#preservices) согласно [свойствам пакета](package-props.md), перезапускаются.
**preinstalled** | [Сервисы](package-props.md#Services), которые необходимо [перезапустить до выкладки](./task/packages.md#preservices) согласно [свойствам пакета](package-props.md), перезапущены.
**installing** | Пакет устанавливается.
**installed** | Пакет установлен.
**restarting** | [Сервисы](package-props.md#Services), которые необходимо [перезапустить после выкладки](./task/packages.md#services) согласно [свойствам пакета](package-props.md), перезапускаются.
**restarted** | [Сервисы](package-props.md#Services), которые необходимо [перезапустить после выкладки](./task/packages.md#services) согласно [свойствам пакета](package-props.md), перезапущены.
**done** | Действия с пакетами завершены.
