# Группы хостов

{% include [Hosts-HostGroupsBI](../_includes/concepts/package-props/id-Hosts/HostGroupsBI.md) %}

Процедуры, выполняемые с группами хостов:

- [Создание группы хостов](#new).
- [Запрос прав на администрирование группы хостов](#AddGroupAdmin).
- [Редактирование группы хостов](#edit).
- [Удаление группы хостов](#HostGroupsDelete).
- [Групповое удаление группы хостов](#GroupHostgroupsDel).
- [Групповое изменение привязки групп хостов к проектам](#HostGroupsMove).

## Создание группы хостов {#new}

{% note alert %}

Вы должны быть [администратором](../access.md#access_admin) проекта, чтобы иметь возможность создать группу хостов. Группы можно создавать только для своих проектов.

{% endnote %}

Чтобы создать группу хостов:

1. Откройте окно создания группы хостов (**Группы** → **Добавить группу**).
    
1. Заполните поля:
    
    #|
    || **Параметр** | **Описание** ||
    || **Имя** | Название группы хостов. ||
    || **Проект** | Проект, к которому относится группа хостов.
    
    Списочное поле. Значения должны быть [определены](projects.md) в {{ serviceName }}е.
    
    {% include [new-project-restriction](../_includes/task/hosts/id-new/project-restriction.md) %} ||
    || **Описание** | Описание группы хостов в свободной форме. ||
    || **Теги** | Список ключевых слов, характеризующих группу хостов.
    
    {% include [new-tags-2-sentence](../_includes/task/repos/id-new/tags-2-sentence.md) %}
    
    {% include [new-task-3-sentence](../_includes/task/repos/id-new/task-3-sentence.md) %} ||
    || **Экспорт в фаервол** | Экспортировать данные о хостах, входящих в состав группы, в NOC-фаервол.
    
    Если опция выбрана, то регистрируемую группу хостов можно указать в правилах фаервола в виде макроса <q>_С_<Название, указанное в поле **Имя** с модификациями>_</q>.
    
    Название группы хостов при этом подвергается следующим изменениям:
    
    - Строчные буквы переводятся в прописные.
    - Дефисы заменяются на нижние подчеркивания.
    - Идущие подряд подчеркивания заменяются на одно.
    
    Например, группе хостов `my-new--group--` соответствует макрос `_С_MY_NEW_GROUP_`.
    
    {% note info %}
    
    Если свойства группы позволяют экспортировать данные о хостах в NOC-фаервол, то все дочерние также доступны для экспорта.
    
    {% endnote %} ||
    || **Дочерние группы** | Список групп хостов, которые должны входить в данную. Могут быть выбраны только группы, которые определены в {{ serviceName }}е и относятся к заданному проекту.
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %}
    
    {% note alert %}
    
    Доступны только те [группы](groups.md), для которых пользователь является администратором группы или [проекта](groups.md#project).
    
    {% endnote %} ||
    || **Родительские группы** | Список групп хостов, в которые должна входить данная. Могут быть выбраны только группы, которые определены в {{ serviceName }}е и относятся к заданному проекту.
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %}
    
    {% include [new-group-restriction](../_includes/task/groups/id-new/group-restriction.md) %} ||
    |#

1. Сохраните изменения (кнопка **Сохранить**).

В результате в {{ serviceName }}е регистрируется информация о группе хостов.

Новая группа не содержит ни одного хоста. Чтобы добавить хост в группу, выберите хост в разделе [Хосты](https://c.yandex-team.ru/hosts) и отредактируйте поле **Группа** (см. описание процедуры [Редактирование хоста](hosts.md)).

## Запрос прав на администрирование группы хостов {#AddGroupAdmin}

{% include [add-admin-audience-restriction1](../_includes/task/projects/id-add-admin/audience-restriction1.md) %}

Администраторы группы хостов — пользователи, ответственные за группу. Администраторы группы хостов имеют право:

- [редактировать](#edit) все параметры группы, за исключением поля **Проект**;
- [редактировать](hosts.md#edit) и [удалять](hosts.md#DeletHost) хосты группы;
- [добавлять](hosts.md#new) в группу новые хосты.
- удалить группу.

Администраторы группы также являются администраторами по отношению ко всем дочерним группам.

Чтобы запросить права администратора группы:

1. Перейдите в [IDM](https://idm.yandex-team.ru). Для доступа к сервису вы должны быть авторизованы во внутреннем [Я.Паспорте](https://passport.yandex-team.ru/).

1. {% include [add-admin-IdmRoleRequest2](../_includes/task/projects/id-add-admin/IdmRoleRequest2.md) %}

    - **Система** — <q>Кондуктор</q>;
    - **Тип ролей** — <q>Роли по проектам</q>;
    - **Проект** — имя проекта в Кондукторе;
    - **Тип ролей внутри проекта** — <q>Роли на группы хостов внутри проекта</q>;
    - **Группа** — имя группы в Кондукторе;
    - **Роль внутри группы** — <q>Администратор группы</q>.

{% include [add-admin-role-approve](../_includes/task/projects/id-add-admin/role-approve.md) %}

## Редактирование группы хостов {#edit}

{% note alert %}

Процедура доступна администраторам группы хостов либо администраторам проекта, к которому относится группа.

{% endnote %}

Для редактирования информации о группе хостов выполните следующие действия:

1. Откройте список доступных групп хостов (**Группы**).
1. Выберите группу хостов из списка. Для ограничения списка отображаемых групп хостов используйте строку поиска.
1. Внесите изменения в поля формы (см. шаг 2 процедуры [Создание группы хостов](#new)).
1. Сохраните изменения (кнопка **Сохранить**).

## Удаление группы хостов {#HostGroupsDelete}

{% include [edit-admin-restriction1](../_includes/task/groups/id-edit/admin-restriction1.md) %}

{% note info %}

При удалении данных о группе хостов также удаляются данные о всех хостах, которые состоят в данной группе. Если данные о хостах, состоящих в удаляемой группе, необходимо сохранить в {{ serviceName }}е, то предварительно [переместите их в другую группу](hosts.md#GroupMoveHosts).

{% endnote %}

Для удаления информации о группе хостов выполните следующие действия:

1. Откройте список доступных групп хостов (**Группы**).
1. Выберите группу хостов из списка. Для ограничения списка отображаемых групп хостов используйте строку поиска.
1. Нажмите кнопку **Удалить**.
1. Подтвердите намерение удалить информацию о группе хостов (кнопка **Ок** в случае удаления пустой группы или **Удалить** в случае удаления группы, частью которой является хотя бы один хост).

В результате выполнения процедуры данные о группе хостов и входящих в нее хостах удаляются из {{ serviceName }}а. Вложенные группы перемещаются на корневой уровень иерархии групп.

## Групповое удаление группы хостов {#GroupHostgroupsDel}

{% include [edit-admin-restriction1](../_includes/task/groups/id-edit/admin-restriction1.md) %}

Для удаления двух и более (в общем случае — одной и более) записей о группах хостов выполните следующие действия:

1. Откройте список доступных групп хостов (**Группы**).
1. Заполните поля выбора, соответствующие удаляемым группам хостов.
1. Выберите значение <q>Удалить</q> в списочном поле под списком доступных групп хостов.
1. Нажмите кнопку **Ок** для удаления данных о выбранных группах хостов.
1. Подтвердите намерение удалить информацию о группе хостов (кнопка **Удалить**).

В результате выполнения процедуры данные о выбранных группах хостов и входящих в них хостах удаляются из {{ serviceName }}а. Вложенные группы перемещаются на корневой уровень иерархии групп.

## Групповое изменение привязки групп хостов к проектам {#HostGroupsMove}

{% note alert %}

Изменять привязку групп хостов можно только в рамках проектов, для которых пользователь является администратором.

{% endnote %}

Для группового изменения привязки групп хостов к [проектам](../package-props.md#Projects) выполните следующие действия:

1. Откройте список доступных групп хостов (**Группы**).
1. Заполните поля выбора, соответствующие перемещаемым группам хостов.
1. Выберите значение <q>Переместить в проект</q> в списочном поле под списком доступных групп хостов.
1. Начните вводить название проекта, к которому необходимо привязать записи о группах хостов. Используйте подсказку автозаполнения для выбора требуемого значения.
1. Нажмите кнопку **Ок**.
1. Сохраните изменения (кнопка **Сохранить**).

В результате выполнения процедуры меняется проект, к которому относятся выбранные группы хостов.
