# Настройка свойств пакета

{% include [test_suites-audience-restriction](../_includes/task/test_suites/id-test_suites/audience-restriction.md) %}

Пакет — это архив, содержащий устанавливаемые файлы и инструкции по их установке. Пакет является основной единицей, которой оперирует {{ serviceName }}.

После сборки и загрузки в [репозиторий](../package-props.md#Repos) информация о пакете автоматически передается в {{ serviceName }}. Данные о пакетах в {{ serviceName }}е регулярно (на данный момент — ежеминутно) синхронизируются с данными репозиториев. Поэтому ручное добавление данных о пакете обычно не требуется. Тем не менее в {{ serviceName }}е предусмотрена возможность [ручной регистрации пакета](#new).

При автоматическом добавлении пакета в {{ serviceName }} многие свойства, влияющие на выкладку, остаются неопределенными. Они указываются при [редактировании](#edit).

{% note alert %}

Часть свойств пакетов доступна для редактирования только пользователям с ролью не ниже Musician. Такие свойства отмечены звездочкой (*).

{% endnote %}

Если пакет перестает использоваться или не выкладывается, то информация о нем [временно удаляется](#DeletePackage). При этом свойства пакета сохраняются в {{ serviceName }}е и могут быть восстановлены.

## Добавление пакета {#new}

Для добавления информации о пакете выполните следующие действия:

1. Откройте окно регистрации данных о пакете (**Пакеты** → **Добавление пакета**).
    
1. Задайте параметры.
    
    {% note info %}
    
    В зависимости от роли пользователя последовательность полей в интерфейсе может различаться.

    Для пользователей Musician или выше поля блока **Дополнительно** отображаются при нажатии кнопки **Дополнительно**.
    
    Для пользователей Audience некоторые поля блока **Дополнительно** отображаются по умолчанию.
    
    {% endnote %}
    
    #|
    || **Параметр** | **Описание** ||
    || **Имя** | Название пакета.
    
    Должно строго совпадать с названием пакета в [репозитории](repos.md). ||
    || **Установка*** | Ограничения, накладываемые на выкладку.
    
    Выберите значение переключателя, соответствующее требуемому методу установки:
    
    - **параллельная** — одновременная выкладка пакета на всех хостах [деплой-листа](#edit_deploy);
    - **последовательная с задержкой** — последовательная выкладка пакета на разные хосты с задержкой, указанной в поле **сек.**. Задержка определяет время с момента окончания выкладки до начала следующей. Если задано отрицательное число (например, <q>-1</q>), то поведение аналогично параллельной установке. ||
    || **Порядок установки** | Порядок выкладки пакета по датацентрам.
    
    Выберите значение переключателя, соответствующее требуемому порядку:
    
    - **везде** — особого порядка установки по датацентрам нет, пакет устанавливается на все [хосты](hosts.md) или [группы хостов](groups.md), входящие в деплой-лист;
    - **по очередям датацентров** — пакет устанавливается последовательно на разные очереди [датацентров](datacenters.md);
    - **по датацентрам** — пакет устанавливается последовательно на разные  [датацентры](datacenters.md).
    
    Опции расположены в порядке увеличения приоритета. Если таск содержит несколько пакетов, ко всем пакетам применяются наиболее приоритетные правила. Например, если пакеты имеют настройки **по очередям датацентров** и по **датацентрам**, все пакеты будут выкладываться по датацентрам.
    
    {% note info %}
    
    У тикетов и тасков, в рамках которых пакеты выкладываются отдельно в каждом датацентре (очереди датацентров), может длительное время сохраняться [служебный статус](../statuses.md#IntStatuses) [dmoved](../statuses.md#IntStatuses_dmoved). Корректные статусы, отражающие ход выкладки для каждого дата-центра, доступны в лог-файле.
    
    {% endnote %} ||
    || **Тикеты*** | Требования к тикету на выкладку данного пакета.
    
    Содержит опцию **Комментарий обязателен к каждому тикету**. Если выбрана, [тикет на выкладку](tickets.md#new) может быть поставлен только при наличии комментария. ||
    || **Репозитории** | Список репозиториев, в которых должен храниться данный пакет.
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %}
    
    Если пакет отсутствует хотя бы в одном из перечисленных репозиториев, тикет на выкладку не принимается к исполнению и выставляется статус [need info](../statuses.md#statuses__needinfo).
    
    Пакет может присутствовать в репозиториях, которые не указаны в данном поле. ||
    || **Блок Дополнительно** ||
    || **Emails** {#email-ui} | Список адресов электронной почты, на которые необходимо отправлять [уведомления](../notifications.md) по связанным с пакетом тикетам. Поле используется для определения списка рассылок. Могут быть указаны адреса, зарегистрированные в домене `yandex-team.ru`. ||
    || **Подписчики** {#subscribes} | Список получателей [уведомлений](../notifications.md) по связанным с пакетом тикетам. Получатели определяются по доменным логинам (используемым для авторизации во внутреннем Яндекс.Паспорте). ||
    || **SMS*** | Список пользователей, которым следует отправлять SMS об успешной выкладке пакета. В качестве значений указываются доменные логины.
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %} ||
    || **Описание** | Описание пакета в свободной форме. ||
    || **Тесты** | Список тестов, которыми проверяется корректность выкладки пакета. Задаются через запятую (могут быть заданы через запятую с пробелом).
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %}
    
    Доступны только тесты, которые [определены](test_suites.md#new) в {{ serviceName }}е. ||
    || **Пре-сервисы*** {#preservices} | Скрипт, содержащий список сервисов и действий, которые должны быть предприняты с ними перед выкладкой пакета (например, останов или перезапуск).
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %}
    
    Доступны только скрипты, которые [определены](services.md#new) в {{ serviceName }}е. ||
    || **Сервисы*** {#services} | Скрипт, содержащий список сервисов и действий, которые должны быть предприняты с ними после выкладки пакета (например, останов или перезапуск).
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %}
    
    Скрипт должен быть [определен](services.md#new) в {{ serviceName }}е. ||
    || **Теги*** | Список ключевых слов, характеризующих пакет.
    
    {% include [new-tags-2-sentence](../_includes/task/repos/id-new/tags-2-sentence.md) %}
    
    {% include [new-task-3-sentence](../_includes/task/repos/id-new/task-3-sentence.md) %} ||
    || **Особенности версионирования** | Опция, позволяющая добавлять версии к имени пакета.
    
    Используется для одновременной установки двух версий одного пакета на один [хост](#edit_deploy).
    
    {% note info %}
    
    Учитывайте возможные конфликты при пересечении файлов в двух версиях одного пакета.
    
    {% endnote %} ||
    || **отделив дефисом** | Доступно только при добавлении версии в имя пакета (заполнено поле выбора **Добавить версию к имени**).
    
    Использовать короткое тире (-) между именем пакета и его версией.
    
    Например, если поле выбора не заполнено, то при выкладке пакет `yandex-package1.0` переименовывается в `yandex-package-1.0`. ||
    || **отрезав билд** | {% include [new-UsTerms](../_includes/task/packages/id-new/UsTerms.md) %}
    
    Исключать слово <q>build</q> из названия пакета. Если поле выбора заполнено, то название пакета, содержащее версию в формате `build.1.0-1`, заменяется на `1.0`. Данная логика позволяет одновременно выкладывать пакеты, которые будут установлены параллельно.
    
    Подробная информация о соглашениях по именованию дебиановских пакетов представлена на странице [http://www.debian.org/doc/debian-policy/ch-controlfields.html#s-f-Version](http://www.debian.org/doc/debian-policy/ch-controlfields.html). ||
    || **и заменив точки на дефисы** | {% include [new-UsTerms](../_includes/task/packages/id-new/UsTerms.md) %}
    
    Менять точки в названии пакетов на короткие тире. ||
    |#

1. Сохраните изменения (кнопка **Сохранить**).

## Редактирование пакета {#edit}

Некоторые параметры пакетов недоступны при [добавлении данных](#new) и могут быть заданы только при редактировании. Большинство дополнительных параметров доступны для редактирования только [администраторам](../access.md).

Для редактирования данных о пакете выполните следующие действия:

1. Откройте [список пакетов](https://c.yandex-team.ru/packages) (**Пакеты**) и выберите пакет.
1. Откройте окно редактирования информации о пакете (**Редактирование пакета**).
1. Внесите изменения в поля формы (см. шаг 2 процедуры [Добавление пакета](#new)).
    
    {% note info %}
    
    Поле **Имя** для редактирования недоступно.
    
    {% endnote %}
    
1. Сохраните изменения (кнопка **Сохранить**).

### Узнайте больше

- [Удаление пакета](#DeletePackage)

## Настройка хостов для выкладки пакета {#edit_deploy}

{% include [edit-project-admin-restriction1](../_includes/task/projects/id-edit/project-admin-restriction1.md) %}

Порядок выкладки пакета на [хосты](../package-props.md#Hosts) или [группы хостов](../package-props.md#DCs) определяется связанными с пакетом [воркфлоу](workflows.md). Перечень воркфлоу, которые применяются к пакету, называют _деплой-листом_ пакета.

Чтобы настроить деплой-лист:

1. Откройте [список пакетов](https://c.yandex-team.ru/packages) (**Пакеты**) и выберите пакет.
1. Перейдите на вкладку **Редактирование деплой-листа**.
1. Введите название [воркфлоу](workflows.md) или [группы](workflow_groups.md) в поле **Воркфлоу или группа воркфлоу**.
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %}
    
    {% note alert %}
    
    Доступны только воркфлоу тех проектов, для которых пользователь определен в качестве администратора. Может быть добавлено неограниченное количество воркфлоу.
    
    {% endnote %}
    
    Выбранные воркфлоу можно удалить кнопкой ![alt-text](../_images/b-delete-deploy.png).

1. Сохраните изменения (кнопка **Сохранить деплой-лист**).

В результате выполнения процедуры пакет связывается с воркфлоу. При выкладке пакет устанавливается на хосты, перечисленные в воркфлоу из деплой-листа.

## Настройка особенностей выкладки пакета {#edit_properties}

{% include [new-musician-restriction1](../_includes/task/projects/id-new/musician-restriction1.md) %}

Общие правила выкладки пакетов задаются с помощью [воркфлоу](workflows.md#new) и применяются ко всем связанным с ним пакетам. Если общие правила вам не подходят, вы можете изменить правила выкладки пакета, настроив его _особенности выкладки_. Особенности выкладки позволяют переопределить:

- возможность автовыкладки пакета;
- порядок установки пакета по датацентрам;
- порядок выкладки пакета на деплой-группы.

Чтобы настроить особенности выкладки:

1. Откройте [список пакетов](https://c.yandex-team.ru/packages) (**Пакеты**) и выберите пакет.
1. Нажмите кнопку **Особенности выкладки**.
1. Выберите воркфлоу для настройки. Вам будут доступны только те воркфлоу, для которых вы определены в качестве администратора проекта.
1. Задайте особенности выкладки для выбранного воркфлоу:
    - Настройте автовыкладку пакета на деплой-группы с помощью опций **Включить** или **Отключить**.
    - Переопределите порядок установки пакета:
        - **нет** — порядок установки пакета остается без изменений;
        - **везде** — особого порядка установки по датацентрам нет, пакет устанавливается на все [хосты](hosts.md) или [группы хостов](groups.md), входящие в деплой-группу;
        - {% include [new-dc-line](../_includes/task/packages/id-new/dc-line.md) %}
        - {% include [new-dc](../_includes/task/packages/id-new/dc.md) %}
    - Укажите, какие деплой-группы можно пропускать при выкладке, с помощью опции **Пропускать**. Опция доступна, только если у воркфлоу определен порядок выкладки на деплой-группы (шаг 3 [добавления воркфлоу](workflows.md#new)) .

1. Сохраните изменения (кнопка **Сохранить**).

Теперь для заданного пакета будут применяться измененные правила выкладки. Для других пакетов, связанных с тем же воркфлоу, правила выкладки не поменяются.

## Настройка одобрений выкладки пакета {#edit_approvers}

{% include [edit-project-admin-restriction1](../_includes/task/projects/id-edit/project-admin-restriction1.md) %}

Одобрение — это разрешение на выкладку пакета. Вы можете [запросить роли одобряторов](project-roles.md#approver) для пользователей, которые будут подтверждать выкладку на деплой-группы вашего проекта.

Чтобы настроить одобрения:

1. Убедитесь, что нужные пользователи обладают ролью одобрятора для вашего проекта. При необходимости [запросите](project-roles.md#approver) роли в IDM.
1. Откройте [список пакетов](https://c.yandex-team.ru/packages) (**Пакеты**) и выберите пакет.
1. Перейдите в окно редактирования одобрений (**Одобрения**).
1. Выберите деплой-группу, для которой вы хотите настроить одобрения.
1. Откройте окно настройки сочетаний одобрений (кнопка ![alt-text](../_images/b-edit.png)).
1. Добавьте необходимое количество сочетаний (кнопка **+**). Для каждого сочетания заполните поля:
    - **Одобряторы** — логины одобряторов;
    - **Необходимо одобрений** — минимальное количество одобрений от сочетания, необходимое для выкладки пакета.
1. Сохраните изменения.

Теперь при создании таска всем одобряторам будут рассылаться письма с предложением подтвердить или отклонить выкладку. До подтверждения выкладки таск переводится в статус `need_approval`.

После получения необходимых одобрений таск переводится в статус `new` и становится доступен для выкладки.

Если хотя бы один из одобряторов отклонил выкладку, таск переходит в статус `rejected`, и его выполнение прекращается.

## Добавление вебхука {#webhooks_new}

Для любого пакета вы можете настроить _вебхук_ — отправку HTTP-уведомлений о переходе [таска](tickets.md) на выкладку пакета в [статус](../statuses.md) **done**. Такой механизм позволяет, например, автоматически запускать тесты после успешной выкладки пакета на деплой-группу.

{% note alert %}

Для работы вебхука необходимо обеспечить доступ [серверов Кондуктора](https://c.yandex-team.ru/groups/vs_conductor) к хосту, в адрес которого будет направлен вебхук. Обычно доступ предоставляют администраторы проекта, к которому относится хост.

{% endnote %}

Чтобы добавить вебхук:

1. Откройте [список пакетов](https://c.yandex-team.ru/packages) (**Пакеты**) и выберите пакет.
1. В окне добавления вебхука (**Вебхуки** → **Добавить вебхук**) задайте параметры:
    - URL хоста, в адрес которого будет направлен HTTP-запрос.
    
    Хост должен располагаться в доменах `yandex-team.ru`, `yandex.net` или `api.newrelic.com`.
    
    - HTTP-метод.
    
    Вы можете выбрать один из методов: [GET](#get) или [POST](#post). Структура запросов для каждого метода приведена ниже.
    
    - [Ветка](../branches.md), которую отслеживает вебхук.
    
1. Выберите опцию **Включен**. Эта опция позволяет включать и выключать вебхук, не удаляя его из {{ serviceName }}а.
1. Сохраните изменения (кнопка **Сохранить**).

Вебхук вызывается при переходе таска в статус **done**. При этом сервер {{ serviceName }}а отправляет HTTP-запрос на указанный URL. Если запрос не был успешным, он повторяется. Всего производится не более трех попыток отправить запрос.

Запрос считается успешным, если выполнено одно из условий:
- получен ответ с кодом в интервале 200-300;
- возникло исключение ReadTimeout (10 секунд).

Если несколько пакетов с совпадающими вебхуками выкладываются в рамках одного таска, вебхук вызывается один раз и содержит информацию обо всех пакетах.

{% list tabs %}

- Структура GET-запросов

    При использовании метода GET данные о выкладке передаются в виде параметров в URI запроса. Все параметры являются обязательными.
    
    ```no-highlight
    https://<URL>/?
     author=<author_login>
    &branch=<branch_name>
    &comment=<comment>
    &deploy_group=<deploy_group_name>
    &modifier=<modifier_login>
    &modifier_id=<id3>
    &new_status=done
    &old_status=<status>
    &packages=<package1>,<package2>,...
    &project=<project_name>
    &raw_branch=<stable|hotfix|fallback>
    &task=<TASK_name>
    &task_id=<id1>
    &ticket_id=<id2>
    &ticket_mailcc=<mail1@yandex-team.ru>,<mail2@yandex-team.ru>,...
    &ticket_tasks_finished=<M>
    &ticket_tasks_total=<N>
    &versions=<version1>,<version2>,...
    &workflow=<workflow_name>
    ```
    
    #|
    || **Параметр** | **Описание** | **Формат** ||
    || `author` | Имя пользователя, создавшего тикет. | Логин на стаффе. ||
    || `branch` | Ветка, в которую был выложен пакет. | Принимает одно из значений:

    - unstable;
    - testing;
    - prestable;
    - stable. ||
    || `comment` | Содержание поля **Комментарий** тикета. | Текстовая строка. ||
    || `deploy_group` | Имя деплой-группы, на которую выложен пакет. | Имя деплой-группы (как в {{ serviceName }}е) ||
    || `modifier` | Имя пользователя, выполнившего выкладку. | Логин на стаффе. ||
    || `modifier_id` | Идентификатор пользователя, выполнившего выкладку. Является внутренним идентификатором {{ serviceName }}а. | Целое число. ||
    || `new_status` | Текущий статус таска. | Всегда имеет значение **done**. ||
    || `old_status` | Cтатус таска до перехода в **done**. | Принимает одно из значений:
    
    - deploying;
    - frozen. ||
    || `packages` | Перечень выложенных пакетов. | Имена пакетов (как в {{ serviceName }}е), разделенные запятой. ||
    || `project` | Имя проекта, на хосты которого были выложены пакеты. | Имя проекта (как в {{ serviceName }}е). ||
    || `raw_branch` | Имя внерегламентной ветки, в которую выложен пакет. Параметр применяется при выкладке в **stable**, **hotfix** или **fallback**. | Принимает одно из значений:
    
    - stable;
    - hotfix;
    - fallback. ||
    || `task` | Имя таска. | Имя таска (как в {{ serviceName }}е). ||
    || `task_id` | Идентификатор таска. Является внутренним идентификатором {{ serviceName }}а. | Целое число. ||
    || `ticket_id` | Номер тикета, содержащего таск. | Целое число. ||
    || `ticket_mailcc` | Список email-адресов, на которые рассылаются уведомления о статусе тикета. | Email-адреса, разделенные запятой. ||
    || `ticket_tasks_finished` | Количество выполненных тасков, включая текущий. | Целое число. ||
    || `ticket_tasks_total` | Общее количество тасков в тикете. | Целое число. ||
    || `versions` | Номера версий выложенных пакетов. | Номера версий пакета (как в {{ serviceName }}е), разделенные запятой. ||
    || `workflow` | Воркфлоу, по которому производится выкладка. | Имя воркфлоу (как в {{ serviceName }}е). ||
    |#

- Структура POST-запросов

    При использовании метода POST данные о выкладке передаются в JSON-теле запроса. Все параметры являются обязательными.
    
    ```javascript
    {
     "task":"<TASK_name>",
     "task_id":{id1},
     "ticket_id":{id2},
     "project":"<project_name>",
     "raw_branch":"<stable|hotfix|fallback>"
     "branch":"<branch_name>",
     "old_status":"<status>",
     "new_status":"done",
     "modifier":"<modifier_login>",
     "modifier_id":{id3},
     "author":"<author_login>",
     "comment":"<comment>",
     "ticket_subscribers":[ "<subscriber_login1>", "<subscriber_login2>" ],
     "ticket_mailcc":[ "<mail1@yandex-team.ru>", "<mail2@yandex-team.ru>" ],
     "packages":[ 
                   { 
                    "package":"<package1>",
                    "version":"<version1>",
                    "prev_version":"<prev_version1>"
                   },
                   { 
                    "package":"<package2>",
                    "version":"<version2>",
                    "prev_version":"<prev_version2>"
                   },
                   ...
                  ]
     "deploy_group":"<deploy_group_name>",
     "workflow":"<workflow_name>",
     "ticket_tasks_total":{N},
     "ticket_tasks_finished":{M}
    }
    ```
    
    Перечень объектов и их описание приведены в таблице:
    
    #|
    || **Объект** | **Описание** | **Формат** ||
    || `task` | Имя таска. | Имя таска (как в {{ serviceName }}е). ||
    || `task_id` | Идентификатор таска. Является внутренним идентификатором {{ serviceName }}а. | Целое число. ||
    || `ticket_id` | Номер тикета, содержащего таск. | Целое число. ||
    || `project` | Имя проекта, на хосты которого были выложены пакеты. | Имя проекта (как в {{ serviceName }}е). ||
    || `raw_branch` | Имя внерегламентной ветки, в которую выложен пакет. Параметр применяется при выкладке в **stable**, **hotfix** или **fallback**. | Принимает одно из значений:
    
    - stable;
    - hotfix;
    - fallback. ||
    || `branch` | Ветка, в которую был выложен пакет. | Принимает одно из значений:
    
    - unstable;
    - testing;
    - prestable;
    - stable. ||
    || `old_status` | Cтатус таска до перехода в **done**. | Принимает одно из значений:
    
    - deploying;
    - frozen. ||
    || `new_status` | Текущий статус таска. | Всегда имеет значение **done**. ||
    || `modifier` | Имя пользователя, выполнившего выкладку. | Логин на стаффе. ||
    || `modifier_id` | Идентификатор пользователя, выполнившего выкладку. Является внутренним идентификатором {{ serviceName }}а. | Целое число. ||
    || `author` | Имя пользователя, создавшего тикет. | Логин на стаффе. ||
    || `comment` | Содержание поля **Комментарий** тикета. | Текстовая строка. ||
    || `ticket_subscribers` | Пользователи, подписанные на уведомления о статусе тикета | Массив логинов пользователей. ||
    || `ticket_mailcc` | Список email-адресов, на которые рассылаются уведомления о статусе тикета. | Массив email-адресов. ||
    || `packages` | Массив, содержащий перечень выложенных пакетов и их свойства. | Массив объектов. ||
    || `deploy_group` | Имя деплой-группы, на которую выложен пакет. | Имя деплой-группы (как в {{ serviceName }}е) ||
    || `workflow` | Воркфлоу, по которому производится выкладка. | Имя воркфлоу (как в {{ serviceName }}е). ||
    || `ticket_tasks_total` | Общее количество тасков в тикете. | Целое число. ||
    || `ticket_tasks_finished` | Количество выполненных тасков, включая текущий. | Целое число. ||
    || **Объекты массива packages** ||
    || `package` | Имя выложенного пакета. | Имя пакета (как в {{ serviceName }}е). ||
    || `version` | Номер версии выложенного пакета | Номер версии пакета (как в {{ serviceName }}е) ||
    || `prev_version` | Версия пакета, которая была установлена на хостах до выкладки. | Номер версии пакета (как в {{ serviceName }}е) ||
    |#

{% endlist %}

## Редактирование вебхука {#webhook_edit}

Для редактирования информации о вебхуке выполните следующие действия:

1. Откройте [список пакетов](https://c.yandex-team.ru/packages) (**Пакеты**) и выберите пакет.
1. Откройте список вебхуков, назначенных пакету (**Вебхуки**).
1. Выберите вебхук из списка и откройте окно редактирования (**редактировать**).
1. Внесите изменения в поля формы (см. шаги 2 и 3 процедуры [Добавление вебхука](#webhooks_new)).
1. Сохраните изменения (кнопка **Сохранить**).

## Тестирование вебхука {#test-webhook}

Чтобы проверить корректность запросов, отправляемых [вебхуком](#webhooks_new), выполните следующие действия:

1. Откройте [список пакетов](https://c.yandex-team.ru/packages) (**Пакеты**) и выберите пакет.
1. Откройте список вебхуков, назначенных пакету (**Вебхуки**).
1. Выберите вебхук из списка и нажмите кнопку **тестировать**.

В результате на указанный для вебхука URL отправляется тестовый запрос, а на экран выводится таблица с информацией о запросе:

- результат выполнения запроса (успешно/неудачно);
- URL запроса;
- метод запроса;
- время отправки запроса;
- заголовки запроса;
- тело запроса.

## Удаление вебхука {#webhook_delete}

Чтобы удалить информацию о вебхуке:

1. Откройте [список пакетов](https://c.yandex-team.ru/packages) (**Пакеты**) и выберите пакет.
1. Откройте список вебхуков, назначенных пакету (**Вебхуки**).
1. Выберите вебхук и нажмите кнопку **удалить**.
1. Подтвердите удаление (кнопка **Ок**).

## Удаление пакета {#DeletePackage}

Пакет, который больше не используется, можно отметить как удаленный. После этого информация о пакете архивируется, а {{ serviceName }} будет игнорировать любые попытки применить изменения к пакету.

Сведения о пакете остаются доступными и могут быть [восстановлены](#Restore).

Чтобы отметить пакет как удаленный, выполните следующие действия:

1. Откройте [список пакетов](https://c.yandex-team.ru/packages) (**Пакеты**) и выберите пакет.
1. Откройте окно редактирования информации о пакете (**Редактирование пакета**).
1. Нажмите кнопку **Удалить**.
1. Подтвердите намерение удалить информацию о пакете (кнопка **OK**).
 Удаленный таким образом пакет будет отмечен знаком ![alt-text](../_images/selected.png) в графе **Удален**. 

## Восстановление информации о пакете {#Restore}

Информация о пакете, который был [отмечен как удаленный](#DeletePackage) из {{ serviceName }}а, может быть восстановлена. После этого пакет снова доступен для любых действий (выкладки, редактирования и пр.).

Для восстановления информации о пакете выполните следующие действия:

1. Откройте [список пакетов](https://c.yandex-team.ru/packages) (**Пакеты**) и выберите пакет.
1. Выберите пакет из списка. Удаленные пакеты отмечены знаком ![alt-text](../_images/selected.png) в столбце **Удалён**. Для ограничения списка отображаемых пакетов используйте строку поиска.
1. Откройте окно редактирования информации о пакете (**Редактирование пакета**).
1. Нажмите кнопку **Оживить**.
