# Тикеты и таски на выкладку

{% include [test_suites-audience-restriction](../_includes/task/test_suites/id-test_suites/audience-restriction.md) %}

После [регистрации информации о пакете](packages.md#new) в {{ serviceName }}е и [определения его свойств](packages.md#edit), может быть поставлен тикет на выкладку.

Один _тикет_ на выкладку может содержать несколько пакетов. Кроме того, один пакет может выкладываться на несколько [деплой-групп](workflows.md#edit_deploy) различных [воркфлоу](workflows.md). Такие тикеты разбиваются на _таски_.

Группирующим объектом для тасков являются деплой-группы тех воркфлоу, которые привязаны к выкладываемым пакетам.

{% cut "Пример" %}

Пусть в рамках тикета выкладываются пакеты, которые связанны с указанными в таблице воркфлоу и деплой-группами:

Пакет | Назначенные воркфлоу  | Соответствующие деплой-группы
:--- | :--- | :---
`package_1` | `workflow_1` | `deploy_1_1`<br/><br/>`deploy_1_2`
`workflow_2` | `deploy_2_1`
`package_2` | `workflow_1` | `deploy_1_1`<br/><br/>`deploy_1_2`
`workflow_2` | `deploy_2_1`
`package_3` | `workflow_3` | `deploy_3_1`
`package_4` | `workflow_4` | `deploy_4_1`<br/><br/>`deploy_4_2`
`package_5` | `workflow_1` | `deploy_1_1`<br/><br/>`deploy_1_2`
`workflow_2` | `deploy_2_1`

Тогда тикет разбивается на следующие таски (которые сгруппированы по деплой-группам):

№№ таска | Группирующая деплой-группа | Список пакетов
:--- | :--- | :---
1 | `deploy_1_1` | `package_1`<br/><br/>`package_2`<br/><br/>`package_5`
2 | `deploy_1_2` | `package_1`<br/><br/>`package_2`<br/><br/>`package_5`
3 | `deploy_2_1` | `package_1`<br/><br/>`package_2`<br/><br/>`package_5`
4 | `deploy_3_1` | `package_3`
5 | `deploy_4_1` | `package_4`
6 | `deploy_4_2` | `package_4`

{% endcut %}

## Создание тикета на выкладку пакета из интерфейса {#new}

Тикеты могут поставить [пользователи](../access.md#access) или [администраторы](../access.md#access){{ serviceName }}а.

Окно вызывается автоматически при запуске {{ serviceName }}а (если в [параметрах учетной записи](users.md) не заполнено поле выбора **Вьетнам**), а также одной из следующих кнопок:

- **Тикеты** → **Создание**. В данном случае все поля окна будут незаполненными;
- **клонировать** на странице со списком тикетов пользователя ( или ). В данном случае заполнены все поля, в которые ранее введены данные;
- **в престэйбл** или **в стэйбл** после закрытия таска на выкладку пакета в ветку [testing](../branches.md#testing). В данном случае заполнены все ранее заполненные поля.

Для создания тикета на выкладку пакета выполните следующие действия:

1. Откройте окно добавления тикета на выкладку пакета.
1. Заполните поля:
    
    #|
    || **Название поля** | **Описание** ||
    || **Ветка** | [Ветка](../branches.md), в которую необходимо выложить пакет.
    
    {% note info %}
    
    Если в [Воркфлоу](workflows.md), назначенном пакету, для выбранной ветки указано несколько деплой-групп, то в рамках тикета, поставленного из интерфейса {{ serviceName }}а, будет предпринята попытка поставить его на хосты всех деплой-групп. Частичная выкладка (на некоторые деплой-группы) доступна в:
    
    - API {{ serviceName }}а (см. описание ресурса `add_ticket` в [Вики](https://wiki.yandex-team.ru/Conductor/API/auth_update/#ticketadd)).
    - Консольной утилите `conductor-utils` (см. описание ключа `--filter` в разделе [Создание тикета из командной строки](#command-line-task-new)).
    
    {% endnote %} ||
    || **Пакет** | Название выкладываемого пакета.
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %}
    
    Могут быть выбраны только пакеты, которые [зарегистрированы](packages.md) в {{ serviceName }}е.
    
    Для поддержания актуального списка пакетов проводится ежеминутный опрос [репозиториев](repos.md) на `dist.yandex.ru`. При обнаружении новых пакетов они добавляются в базу {{ serviceName }}а.
    
    Содержит опцию **удалить**. Если выбрана, то тикет сводится к удалению указанной версии (а не установке). ||
    || **Версия** | Версия выкладываемого пакета. ||
    || **Комментарий** | Комментарий к тикету на выкладку пакета.
    
    Обязателен в следующих случаях:
    
    - Для выкладки требуются дополнительные действия со стороны администраторов.
    - [Свойства пакета](packages.md) запрещают ставить тикет, если не заполнено данное поле. ||
    || **Оповестить** | {% include [new-subscribers-description](../_includes/task/packages/id-new/subscribers-description.md) %}
    
    Дополняет список, [определенный для пакета](packages.md#subscribes). ||
    || **Также оповестить** | {% include [new-emails-description](../_includes/task/packages/id-new/emails-description.md) %}
    
    Дополняет список, [определенный для пакета](packages.md#email-ui). ||
    || **Не перезапускать сервисы** | Выкатить пакет без перезапуска сервисов, даже если это противоречит свойствам пакета.
    
    Некоторые сервисы требуют перезапуска после выкладки. Перезапуск может быть длительной процедурой, приводящей к деградациям (например, сбросу кешей). Если в пакете выкатываются незначительные изменения, отказ от перезапуска может быть оправданным. ||
    || **Не выкладывать автоматически** {#autoinstall} | Не использовать автоадмина при установке пакета.
    
    Если опция выбрана, пакет не выкладывается автоматически даже в том случае, если соответствующая настройка указана в [свойствах воркфлоу](workflows.md#new).
    
    Используется, например, в тех случаях, когда до или после установки пакета требуется выполнить действия, указанные в поле **Comment**. ||
    |#

    {% note alert %}
    
    Пользователи с ролью Passerby могут создать тикет только при условии, что им разрешена выкладка на **все** задействованные хосты.
    
    {% endnote %}

1. Нажмите кнопку **Сохранить**.

В результате в {{ serviceName }}е регистрируется тикет на выкладку пакета. Ссылка на страницу тикета доступна в [уведомлениях](../notifications.md).

Если пакет выкладывается в тестовые [ветки](../branches.md) (unstable, testing или prestable), то для следующей выкладки пакета (в ветки testing, prestable и/или [stable](../branches.md#stable)) необходимо использовать кнопки **в тестинг**, **в престэйбл** и/или **в стэйбл** на странице тикета.

Для каждого тикета доступен журнал событий (ссылка **Логи** на странице тикета). Для тикетов, выкладываемых с помощью `conductor-agent`, таски которых находятся в [статусе](../statuses.md) deploying, дополнительно доступна инфографика о ходе установки пакета (**Логи** → **Просмотр**).

### Узнайте больше

- [Как выкатить несколько пакетов в одном тикете?](../appendecies/faq.md#manypacksinoneticket)
- [Как выкатить пакеты в строгом порядке?](../appendecies/faq.md#packagesinconcreteorder)

## Актуализация пакетов {#regenerate-task}

Пакеты выкладываются на [хосты](hosts.md) деплой-групп, назначенных для [воркфлоу](workflows.md). Состав деплой-групп может меняться. В этом случае пакеты, уже выложенные по соответствующему воркфлоу, следует также установить на добавленные хосты и группы.

Для оптимизации этого процесса в {{ serviceName }}е предусмотрена _актуализация пакетов_. В случае добавление новых деплой-групп или воркфлоу последний тикет на выкладку пакета по этим правилам может быть восстановлен. Установка при этом будет выполнена только на новые хосты.

Для актуализации пакетов выполните следующие действия:

1. Откройте [список пакетов](https://c.yandex-team.ru/packages) (**Пакеты**) и выберите пакет.
1. Перейдите к списку тикетов на выкладку пакета (**Тикеты**) и выберите последний из списка.
1. Нажмите кнопку **актуализировать таски**.
    
    {% note alert %}
    
    Кнопка **доступна**, если:
    
    - с предыдущей выкладки пакету назначены новые воркфлоу или деплой-группы;
    - тикет на выкладку пакета находится в [статусе](../statuses.md) **in work** или **done**;
    - отсутствуют более свежие тикеты на выкладку данных пакетов с выставленными аналогичным образом опциями **удалить**.

    Кнопка **недоступна**, если в предыдущей выкладке использовались [фильтры](#filter-desc).
    
    {% endnote %}
    
1. Нажмите кнопку ![alt-text](../_images/b-start-new-task.png) для тех тасков, у которых она доступна.

В результате тикет, в рамках которого актуализированы пакеты, повторно открывается. Регистрируются таски для выкладки в соответствии с новыми деплой-группами.

{% cut "Примеры" %}

Пусть успешно выполнен тикет на выкладку `ticket_1`, описанный в таблице ниже.

Название пакета | Действие с пакетом | Версия | Состав деплой-групп
:--- | :--- | :--- | :---
`package_1` | Установить | 2.222 | `host_1_1`<br/><br/>`host_1_2`
`package_2` | Удалить | 1.111 | `host_2_1`<br/><br/>`host_2_2`

Поведение кнопки **актуализировать таски** зависит от изменений в составе деплой-группы и свойств новых тикетов.

- [Изменена деплой-группа](#deploy-group-change).
- [Изменена версия устанавливаемого пакета](#installed-package-version).
- [Создан тикет на выкладку одного из пакетов](#ticket-to-deply-one-of-the-packages).
- [Изменено действие с пакетом](#what-to-do-with-the-project).

#### Изменена деплой-группа

Для пакета `package_1` деплой-группа расширена хостом `host_1_3`, а для `package_2` — хостом `host_2_3`.

В данном случае тикету `ticket_1` добавляется кнопка **актуализировать таски**.

#### Изменена версия устанавливаемого пакета

Пусть после успешного выполнения тикета `ticket_1` произведены следующие действия:

1. Выполнен тикет на выкладку `ticket_2`, описанное в таблице ниже.
    
    Название пакета | Действие с пакетом | Версия | Состав деплой-групп
    ----- | ----- | ----- | -----
    `package_1` | Установить | **2.223** | `host_1_1`<br/><br/>`host_1_2`
    `package_2` | Удалить | 1.111 | `host_2_1`<br/><br/>`host_2_2`
    
1. Расширены составы деплой-групп. Для пакета `package_1` — хостом `host_1_3`, а для `package_2` — хостом `host_2_3`.

В данном случае кнопка **актуализировать таски** перемещается с тикета `ticket_1` на `ticket_2`.

#### Изменено действие с пакетом

{% include [regenerate-task-ticket-1-successfully-deployed](../_includes/task/tickets/id-regenerate-task/ticket-1-successfully-deployed.md) %}

1. Выполнен тикет на выкладку `ticket_3`, описанное в таблице ниже.
    
    Название пакета | Действие с пакетом | Версия | Состав деплой-групп
    :--- | :--- | :--- | :---
    `package_1` | **Установить** | 2.222 | `host_1_1`<br/><br/>`host_1_2`
    `package_2` | **Установить** | 1.111 | `host_2_1`<br/><br/>`host_2_2`
    
1. Расширены составы деплой-групп. Для пакета `package_1` — хостом `host_1_3`, а для `package_2` — хостом `host_2_3`.

В данном случае кнопка **актуализировать таски** одновременно доступна для тикета `ticket_1` и `ticket_3`.

#### Создан тикет на выкладку одного из пакетов

{% include [regenerate-task-ticket-1-successfully-deployed](../_includes/task/tickets/id-regenerate-task/ticket-1-successfully-deployed.md) %}

1. Выполнен тикет на выкладку `ticket_4`, описанный в таблице ниже.

    Название пакета | Действие с пакетом | Версия | Состав деплой-групп
    :--- | :--- | :--- | :---
    `package_1` | Установить | **2.224** | `host_1_1`<br/><br/>`host_1_2`

1. Расширены составы деплой-групп. Для пакета `package_1` — хостом `host_1_3`, а для `package_2` — хостом `host_2_3`.

В данном случае кнопка **актуализировать таски** одновременно доступна для тикетов `ticket_1` и `ticket_4`.

{% endcut %}

## Создание тикета из командной строки {#command-line-task-new}

Тикет на выкладку пакета может быть создан в командной строке без веб-интерфейса {{ serviceName }}а. Для этого используется утилита `conductor-ticket`, устанавливаемая из пакета [conductor-utils](https://github.yandex-team.ru/debian/conductor-utils).

Для создания тикета на выкладку пакета из командной строки выполните следующие действия:

1. Откройте страницу настроек учетной записи пользователя (**Настройки**).
1. Задайте значение **Аутентификационной куки** в одноименном поле.
1. Задайте IP-адреса машин, с которых будут ставиться тикет из командной строки (в поле **ACL**).
1. Сохраните изменения (кнопка **Сохранить**).
1. Запустите утилиту.

    Формат запуска:
    
    ```no-highlight
    conductor-ticket [
                      --auth
                     <значение куки>
                      --oauth
                     <значение OAuth-токена>
                      --comment
                     "<комментарий>"
                      --cc
                     <адреса уведомлений>
                      --host
                     <адрес хоста>
                      --branch
                     <адрес хоста>
                      --skip-restart
                     
                      --no-autoinstall
                     
                      --filter
                     <значение>] <пакет 1>=<версия пакета> <пакет 2>=<версия пакета> .. <пакет N>=<версия пакета>
    ```
    
    Основные ключи запуска приведены в таблице ниже.
    
    #|
    || **Ключ** | **Описание** ||
    || `--auth` | Значение авторизационной куки, заданное на шаге 2.
    
    По умолчанию значение считывается из файла `~/.conductor_auth` или `.conductor_auth` (в каталоге, из которого запускается). ||
    || `--oauth` | Значение OAuth-токена для аутентификации.
    
    По умолчанию считывается из файла `~/.conductor_oauth`.
    
    Информация о получении OAuth-токена приведена в разделе [Отладочный токен](https://doc.yandex-team.ru/oauth/dg-internal/tasks/get-oauth-token.xml) документа [OAuth-авторизация. Руководство разработчика](/oauth/dg/concepts/about.xml). В качестве clid используйте значение <q>eb3c509c74b649cd8411ffc154543fe0</q>. ||
    || `--comment` | Комментарий к тикету на выкладку пакета.
    
    Обязателен в следующих случаях:
    
    - Для выкладки требуются дополнительные действия со стороны администраторов.
    - [Свойства пакета](packages.md) запрещают ставить тикет, если не заполнено данное поле. ||
    || `--cc` | {% include [new-subscribers-description](../_includes/task/packages/id-new/subscribers-description.md) %}
    
    Дополняет список, [определенный для пакета](packages.md#subscribers). ||
    || `--host` | Адрес хоста, по которому доступна версия {{ serviceName }}а, в которой следует поставить тикет на выкладку.
    
    Используется, если выкладку на тестовом экземпляре {{ serviceName }}.
    
    По умолчанию используется значение `c.yandex-team.ru`. ||
    || `--branch` | {% include [new-branch-desc](../_includes/task/tickets/id-new/branch-desc.md) %}
    
    По умолчанию используется значение <q>[testing](../branches#branches__testing)</q>. ||
    || `--skip-restart` | {% include [new-skip-restart-desc-sentence-1](../_includes/task/tickets/id-new/skip-restart-desc-sentence-1.md) %}
    
    {% include [new-skip-restart-desc-sentence-2](../_includes/task/tickets/id-new/skip-restart-desc-sentence-2.md) %}
    
    По умолчанию перезапуск выполняется (если настроен). ||
    || `--no-autoinstall` | {% include [new-dont-use-auto-sentence-1](../_includes/task/tickets/id-new/dont-use-auto-sentence-1.md) %}
    
    {% include [new-dont-use-auto-sentence-2](../_includes/task/tickets/id-new/dont-use-auto-sentence-2.md) %}
    
    Используется, например, в тех случаях, когда до или после установки пакета требуется выполнить действия, указанные в ключе `--comment`.
    
    По умолчанию автоадмин используется (если настроен). ||
    || `--filter` {#command-line-task-new__filter-desc} | Список деплой-групп (создаются в рамках [воркфлоу](workflows.md#new)), на хосты которых необходимо выкладывать пакет. Количество передаваемых значений не ограничено.
    
    В качестве значения можно указать:
    
    - **Название проекта**.
        
        В данном случае:
        
            1. Выбираются все воркфлоу, связанные с проектом.
            1. Отбираются все деплой-группы выбранных воркфлоу, которые определены для ветки, указанной в ключе `--branch`.
            
        Пакет устанавливается на все хосты найденных деплой-групп.
        
        Формат указания: `--filter: <название проекта>`
    
    - **Название воркфлоу**.
        
        В данном случае выбираются все деплой-группы указанного воркфлоу, которые определены для ветки, указанной в ключе `--branch`.
        
        Формат указания: `--filter: <название проекта>/<название воркфлоу>`
        
    - **Название деплой-группы**.
    
        В данном случае выкладка выполняется на все хосты перечисленных деплой-групп.
        
        Формат указания: `--filter: <название проекта>/<название воркфлоу>/<название деплой-группы>`
        
    - **Название пакета и версию**.
        
        В данном случае выбираются все деплой-группы, которые использовались для установки указанного пакета указанной версии. Для указания диапазона значения можно использовать символ <q>* </q>. Например, если указана конструкции <q>2.*</q>, будут выбраны все деплой-группы, использовавшиеся для установки пакетов с мажорной версией 2.
        
        Формат указания: `<пакет>=<версия>`
    
    По умолчанию выкладка выполняется в те группы, которые определены для выкладываемого пакета в рамках связанных воркфлоу. ||
    |#

    Для вызова полной информации об утилите выполните `conductor-ticket --help`.

{% cut "Пример" %}

Следующая команда создает тикет на выкладку пакетов `yandex-pull-the-brakes` версии 1.42 и `yandex-stop-the-train` версии 2.118. Значение авторизационной куки — <q>iminahurrytomeetmybelovedmother</q>. Выкладка выполняется в ветку <q>stable</q>.

```no-highlight
conductor-ticket
           --auth 
          iminahurrytomeetmybelovedmother
           --comment
          "фикс для стучащих колес"
           --branch
          stable yandex-pull-the-brakes=1.42 yandex-stop-the-train=2.118
```

{% endcut %}

В результате выполнения процедуры в {{ serviceName }}е регистрируется тикет на выкладку указанных пакетов.

{% note info %}

Значение авторизационной куки может быть задано в файле `~/.conductor_auth` или `.conductor_auth` текущей директории. В данном случае использование опции `--auth` не требуется.

{% endnote %}

### Узнайте больше

- [Оригинал описания процедуры создания тикета на выкладку пакета через командную строку](http://arikon.at.yandex-team.ru/replies.xml?parent_id=1532&item_no=1530)

## Запуск выкладки {#deployment}

{% note alert %}

Процедура доступна только администраторам проекта.

{% endnote %}

Пакеты, входящие в таск, могут быть выложены в автоматическом и ручном режиме. За возможность автоматической выкладки отвечают:

- [настройки](workflows.md#new) автовыкладки воркфлоу;
- [особенности выкладки](packages.md#edit_properties) пакета;
- [расписание автовыкладки](projects.md#shedule) проекта;
- [настройки](#autoinstall) автовыкладки тикета.

Если выкладка не может быть запущена автоматически, ее можно запустить в ручном режиме. Для этого:

1. Откройте список тикетов ([Тикеты](https://c.yandex-team.ru/tickets/all)).
1. Перейдите в окно **Открытые** и выберите таск.
1. Нажмите кнопку ![alt-text](../_images/b-start-new-task.png) , чтобы запустить выкладку. Кнопка доступна только для тех тасков, по отношению к которым вы являетесь администратором проекта.

В результате выполнения процедуры запускается выкладка по таску. Вы можете в любой момент приостановить выкладку, нажав на кнопку ![alt-text](../_images/b-pause-task.png).
