# Группы воркфлоу

{% include [workflows-project-admin-restriction](../_includes/task/workflows/id-workflows/project-admin-restriction.md) %}

Каждый пакет может устанавливаться на разные хосты в соответствии с разными [воркфлоу](workflows.md). Чтобы привязать к пакету несколько воркфлоу, их можно объединить в _группы_.

Группы также позволяют объединять воркфлоу, относящиеся к разным [проектам](projects.md).

Процедуры, выполняемые с группами воркфлоу:

- [Добавление группы воркфлоу](#new).
- [Редактирование группы воркфлоу](#edit).
- [Редактирование деплоя](#edit_deploy).
- [Удаление группы воркфлоу](#delete-workflow-group).

## Добавление группы воркфлоу {#new}

Для регистрации информации о группе воркфлоу выполните следующие действия:

1. Откройте окно регистрации информации группе воркфлоу (**Группы воркфлоу** → **Добавить группу воркфлоу**).
1. Заполните поля:
    
    #|
    || **Параметр** | **Описание** ||
    || **Имя** | Название группы воркфлоу. Должно быть уникальным.
    
    Если группа с введенным именем уже зарегистрирована в {{ serviceName }}е, при попытке сохранить информацию будет возвращено предупреждение. Необходимо указать уникальное значение. ||
    || **Группы воркфлоу** | Группы воркфлоу, которые необходимо включить в текущую.
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %}
    
    Доступны только значения, зарегистрированные в {{ serviceName }}е и относящиеся к проекту, для которого текущий пользователь является администратором.
    
    Выбранные значения отмечаются символом ![alt-text](../_images/b-checked.png).
    
    Для удаления значения из списка нажмите кнопку ![alt-text](../_images/b-delete.png). ||
    || **Воркфлоу** | Воркфлоу, которые необходимо включить в текущую группу.
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %}
    
    Доступны только значения, зарегистрированные в {{ serviceName }}е и относящиеся к проекту, для которого текущий пользователь является администратором.
    
    Для ограничения области поиска одним проектом можно указать его в формате: `<проект>.<название воркфлоу>`. Например, если в поле ввести значение <q>vs.</q>, будут отображаться только воркфлоу проекта vs.
    
    {% include [new-chosen-values](../_includes/task/workflow_groups/id-new/chosen-values.md) %}
    
    {% include [new-to-delete](../_includes/task/workflow_groups/id-new/to-delete.md) %} ||
    |#
    
1. Сохраните изменения (кнопка **Сохранить**).

В результате выполнения процедуры в {{ serviceName }}е регистрируется информация о группе воркфлоу. Она может быть назначена пакету в [свойствах](packages.md).

## Редактирование группы воркфлоу {#edit}

Чтобы отредактировать группу воркфлоу, выполните следующие действия:

1. Откройте список доступных групп воркфлоу (**Группы воркфлоу**).
1. Выберите группу воркфлоу из списка и нажмите кнопку **Редактирование**.
1. Внесите изменения в поля формы (см. шаг 2 процедуры [Добавление группы воркфлоу](#new)).
1. Сохраните изменения (кнопка **Сохранить**).

В результате выполнения процедуры в {{ serviceName }}е изменяется информация о группе воркфлоу.

## Редактирование деплоя {#edit_deploy}

{% note alert %}

Редактирование деплоя доступно только в том случае, если пользователь является администратором проекта для **всех** воркфлоу, входящих в группу.

{% endnote %}

_Деплоем_ называют перечень пакетов, при выкладке которых применяется группа воркфлоу. Вы можете добавить в деплой любое количество пакетов.

Добавление пакета в деплой группы воркфлоу и добавление группы воркфлоу в [деплой-лист](packages.md) пакета — равнозначные действия. Обе процедуры устанавливают связь между пакетом и группой воркфлоу.

Чтобы отредактировать деплой:

1. Откройте список доступных групп воркфлоу (**Группы воркфлоу**).
1. Выберите группу воркфлоу из списка и нажмите кнопку **Редактировать деплой**.
1. Заполните поля:
    
    #|
    || **Параметр** | **Описание** ||
    || **Копировать деплой** | Название воркфлоу (или группы воркфлоу), из которого нужно скопировать деплой (список пакетов, которые должны выкладываться в соответствии с правилами). Должно соответствовать одному из зарегистрированных в {{ serviceName }}е.
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %} ||
    || **Переместить пакеты этого ↑ воркфлоу (или группы) в текущий** | Опция, позволяющая перенести список пакетов, определенных для воркфлоу, указанного в поле **Копировать деплой**, в текущую группу.
    
    Если опция выбрана, после сохранения пакеты отвязываются от выбранной группы воркфлоу и привязываются к текущей. ||
    || **Блок Пакеты** | Содержит список пакетов, которые необходимо выкладывать в соответствии с текущей группой воркфлоу.
    
    Возможные действия с пакетами:
    
    - Добавить. Введите название в поле (справа от списка) и выберите нужно значение. Выбранные пакеты отмечается символом ![alt-text](../_images/b-checked.png).
    - Удалить. Выберите пакет из списка и нажмите кнопку ![alt-text](../_images/b-delete.png). ||
    |#
    
1. Сохраните изменения (кнопка **Сохранить**).

В результате меняется список пакетов, которые должны устанавливаться в соответствии с текущим воркфлоу.

## Удаление группы воркфлоу {#delete-workflow-group}

Чтобы удалить группу воркфлоу:

1. Откройте список доступных групп воркфлоу (**Группы воркфлоу**).
1. Выберите группу воркфлоу из списка и нажмите кнопку **Редактирование**.
1. Нажмите кнопку **Удалить**.
1. Подтвердите намерение удалить информацию о воркфлоу (кнопка **ОК**).

В результате выполнения процедуры информация о группе воркфлоу удаляется из {{ serviceName }}а. Связь с пакетами, завязанными на данную группу воркфлоу, разрывается.
