# Группы хостов

Запросы позволяют получить список групп хостов и подробную информацию по любой из них..

#### Список групп хостов

```
{{ host }}/{{ api-ver }}/groups
```

Вы можете фильтровать группы по времени создания или изменения с помощью параметра `filter`:

```
{{ host }}/{{ api-ver }}/groups/?filter[created_at]=<дата1>..<дата2>&filter[updated_at]=<дата3>..<дата4>
```

Даты записываются в формате ISO-8601: `YYYY-MM-DD` или `YYYY-MM-DDThh:mm:ss±hh:mm`.

#### Параметры определенной группы хостов

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>
```

## Связанные объекты {#section_zr4_w5l_gbb}

#### Идентификатор проекта, к которому отнрсится группа

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/relationships/project
```

#### Параметры проекта, к которому относится группа

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/project
```

#### Идентификаторы вышестоящих групп хостов

Идентификаторы родительских групп:

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/relationships/parents
```

Идентификаторы всех предков группы:

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/relationships/ancestors
```

#### Развернутый список вышестоящих групп хостов

Список родительских групп:

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/parents
```

Список всех предков группы:

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/ancestors
```

#### Идентификаторы вложенных групп хостов

Идентификаторы дочерних групп:

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/relationships/children
```

Идентификаторы всех потомков группы:

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/relationships/descendants
```

#### Развернутый список вложенных групп хостов

Список дочерних групп:

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/children
```

Список всех потомков группы:

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/descendants
```

#### Идентификаторы хостов группы

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/relationships/hosts
```

#### Развернутый список хостов группы

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/hosts
```

#### Идентификаторы макросов, относящихся к группе

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/relationships/macroses
```

#### Развернутый список макросов, относящихся к группе

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/macroses
```

#### Идентификаторы тегов группы

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/relationships/tags
```

#### Развернутый список тегов группы

```
{{ host }}/{{ api-ver }}/groups/<id группы хостов>/tags
```

