# Хосты

Запросы позволяют получить список хостов и подробную информацию по любому из них..

#### Список хостов

```
{{ host }}/{{ api-ver }}/hosts
```

Вы можете фильтровать хосты по времени создания или изменения с помощью параметра `filter`:

```
{{ host }}/{{ api-ver }}/hosts?filter[created_at]=<дата1>..<дата2>&filter[updated_at]=<дата3>..<дата4>
```

Даты записываются в формате ISO-8601: `YYYY-MM-DD` или `YYYY-MM-DDThh:mm:ss±hh:mm`.

#### Параметры определенного хоста

```
{{ host }}/{{ api-ver }}/hosts/<id хоста>
```

## Связанные объекты {#section_zr4_w5l_gbb}

#### Идентификатор датацентра, к которому относится хост

```
{{ host }}/{{ api-ver }}/hosts/<id хоста>/relationships/datacenter
```

#### Параметры датацентра, к которому относится хост

```
{{ host }}/{{ api-ver }}/hosts/<id хоста>/datacenter
```

#### Идентификатор группы, в которую входит хост

```
{{ host }}/{{ api-ver }}/hosts/<id хоста>/relationships/group
```

#### Параметры группы, в которую входит хост

```
{{ host }}/{{ api-ver }}/hosts/<id хоста>/group
```

#### Идентификатор агента

```
{{ host }}/{{ api-ver }}/hosts/<id хоста>/relationships/agent
```

#### Параметры агента

```
{{ host }}/{{ api-ver }}/hosts/<id хоста>/agent
```

#### Идентификаторы тегов хоста

```
{{ host }}/{{ api-ver }}/hosts/<id хоста>/relationships/tags
```

#### Развернутый список тегов хоста

```
{{ host }}/{{ api-ver }}/hosts/<id хоста>/tags
```

