# Структура запросов

Общий вид запросов к API:

```
GET /<api_version>/<resources>/<resource_id>/?<param1>=<value1>&<param2>=<value2> HTTP/1.1 
Host: https://api.directory.yandex.ru 
Authorization: OAuth <OAuth-token> 
Accept: application/json
...
```

## Методы {#section_b4w_2qq_p1b}

API поддерживает только метод `GET`. Метод позволяет получить информацию об объекте или списке объектов.

## Ресурс {#section_nfm_1p3_t1b}

#### api_version

Версия API Кондуктора. Актуальная версия API — `{{ api-ver }}`.

####  resources

Тип ресурса, к которому обращается API:

- `datacenters` — [датацентры](datacenters.md).
    
- `deploy_group_deploys` — [успешные выкладки на деплой-группы](deploy_group_deploys.md).
    
- `deploy_groups` — [деплой-группы](deploy_groups.md).
    
- `deploy_settings` — [настройки выкладки](deploy_settings.md).
    
- `deploy_specifiers` — [деплой-пары](deploy_specifiers.md).
    
- `groups` — [группы хостов](groups.md).
    
- `hosts` — [хосты](hosts.md).
    
- `macroses` — [макросы](macroses.md).
    
- `packages` — [пакеты](packages.md).
- `package_versions` —[ версии пакетов](package_versions.md).
    
- `projects` — [проекты](projects.md).
    
- `repos` — [репозитории](repos.md).
    
- `tags` — [теги](tags.md).
    
- `tasks` — [таски на выкладку](tasks.md).
    
- `tickets` — [тикеты на выкладку](tickets.md).
    
- `users` — [пользователи](users.md).
    
- `workflows` — [воркфлоу](workflows.md).
    

#### resource_id

Идентификатор ресурса.

#### param

Некоторые запросы содержат дополнительные параметры. Такие параметры описаны в разделах, посвященных запросам к API.

## Заголовки {#section_p1c_cpq_p1b}

Каждый запрос к API должен сопровождаться HTTP-заголовками:

- `Host` — содержит адрес узла, предоставляющего API. Всегда должен иметь значение `{{ host }}`.
    
- `Authorization` — содержит OAuth-токен в формате `OAuth <значение токена>, например:`
    
    ```
    Authorization: OAuth 0c4181a7c2cf4521964a72ff57a34a07
    ```
    
    Заголовок необходимо передавать только если вы используете OAuth-авторизацию.
    
- `Accept` — ожидаемый формат данных ответа. Всегда должен иметь значение `application/json`.
    

Некоторые запросы могут сопровождаться дополнительными заголовками. Такие заголовки описаны в разделах, посвященных запросам к API.

## Запрос списка объектов {#section_isz_kl4_r1b}

В ответ на некоторые запросы API формирует список объектов (например, список хостов или тикетов). Для экономии ресурсов такой список разбивается на отдельные страницы. Ответ на запрос содержит только одну страницу. Вы можете управлять постраничным отображением с помощью параметров запроса:

- `page[number]` — номер страницы ответа. Значение по умолчанию — `1`.
    
- `page[size]` — число объектов на странице. Значение по умолчанию — `10`.
    

{% note warning %}

Результаты такого запроса не кэшируются. При переключении между страницами список объектов строится заново, а ответ может содержать позиции, которые не учитывались на предыдущей странице.

{% endnote %}


