# Структура ответов

Общий вид ответов API Кондуктора:

```
HTTP/1.1 <код состояния>
Content-Type: application/json; charset=utf-8
X-Request-ID: <id ответа>
…
{json-object} 
```

## Код состояния {#section_btt_cqj_r1b}
|**Код:**|**Описание**|
|-----|-----|
|`200 OK`|Запрос успешно выполнен.|
|`400 Bad Request`|Неправильный формат запроса. Описание ошибок приведено в теле ответа.|
|`403 Forbidden`|У пользователя или приложения нет прав на доступ к ресурсу, запрос отклонен.|
|`404 Not Found`|Запрашиваемый ресурс не найден.|
|`500 Internal Server Error`|Внутренняя ошибка сервиса. Попробуйте повторно отправить запрос через некоторое время.|


## Заголовки {#section_ngq_2qj_r1b}

Ответы API сопровождаются обязательными HTTP-заголовками:

- `Content-Type` — формат данных тела ответа. Всегда имеет значение `application/json; charset=utf-8`.
    
- `X-Request-ID` — уникальный идентификатор ответа.
    

Некоторые ответы сопровождаются дополнительными заголовками. Такие заголовки описаны в разделах, посвященных запросам к API.

## Тело ответа {#section_jjv_2qj_r1b}

Тело ответа содержит информацию в формате JSON. Структура ответа зависит от характера запроса:

- [Объект](#dlentry_x3p_r5h_fbb).
    
- [Список идентификаторов объектов](#dlentry_ejp_r5h_fbb).
    
- [Развернутый список объектов](#dlentry_ljp_r5h_fbb).
    

#### Объект {#dlentry_x3p_r5h_fbb}

Ответ содержит информацию об определенном объекте: его идентификатор, тип, набор атрибутов и связи с другими объектами.

```
{
  "data":
    {
      "id": "<идентификатор объекта>",
      "type": "<тип объекта>",
      "links": {
        "self": "<ссылка на объект>"
      },
      "attributes": { "<атрибут1>":"<значение1>", "<атрибут2>":"<значение2>", ...}
      "relationships": {
        "<relationship1>": {
          "links": {
            "self": "<ссылка на список идентификаторов связанных объектов>",
            "related": "<ссылка на развернутый список связанных объектов>"
          }
        },
        "<relationship2>": {
          "links": {
            "self": "<ссылка на список идентификаторов связанных объектов>",
            "related": "<ссылка на развернутый список связанных объектов>"
          }
        },
        ...
      }
}
```

#### Список идентификаторов объектов {#dlentry_ejp_r5h_fbb}

Ответ содержит список объектов в компактном виде. Для каждого объекта указываются только его тип и идентификатор.

```
{
    "links": {
        "self": "<ссылка на этот список>",
        "related": "<ссылка на развернутый список>"
    },
    "data": [
        {
            "type": "<тип объекта>",
            "id": "<id>"
        },
        {
            "type": "<тип объекта>",
            "id": "<id>"
        },
        ...
    ]
}
```

#### Развернутый список объектов {#dlentry_ljp_r5h_fbb}

Список содержит развернутую информацию об объектах. Для каждого объекта указываются идентификатор, тип, набор атрибутов и связи.

```
{
  "data": [
    {
      "id": "<идентификатор объекта>",
      "type": "<тип объекта>",
      "links": {
        "self": "<ссылка на объект>"
      },
      "attributes": { "<атрибут1>":"<значение1>", "<атрибут2>":"<значение2>", ...}
      "relationships": {
        "<relationship1>": {
          "links": {
            "self": "<ссылка на список идентификаторов связанных объектов>",
            "related": "<ссылка на развернутый список связанных объектов>"
          }
        },
        "<relationship2>": {
          "links": {
            "self": "<ссылка на список идентификаторов связанных объектов>",
            "related": "<ссылка на развернутый список связанных объектов>"
          }
        },
        ...
      },
    ...
  ],
  "meta": {
    "page[size]": <число объектов на странице ответа>,
    "page[number]": <номер страницы>,
    "page_count": <общее число страниц>
  },
  "links": {
    "first": "ссылка на первую страницу",
    "next": "ссылка на следующую страницу",
    "last": "ссылка на последнюю страницу"
  }
}
```

## Сообщение об ошибке

Ответ содержит сведения об ошибке: ее тип, описание, код и статус.

```
{
  "errors": [
    {
      "title": "<Тип ошибки>",
      "detail": "<Описание ошибки>",
      "code": "<код ошибки>",
      "status": "400"
    }
  ],
  "meta": {
    "page[size]": <число объектов на странице ответа>,
    "page[number]": <номер страницы>,
  }
}
```
|**Тип:**|**Код:**|
|-----|-----|
|`VALIDATION_ERROR`|`100`|
|`INVALID_RESOURCE`|`101`|
|`FILTER_NOT_ALLOWED`|`102`|
|`INVALID_FIELD_VALUE`|`103`|
|`INVALID_FIELD`|`104`|
|`PARAM_NOT_ALLOWED`|`105`|
|`PARAM_MISSING`|`106`|
|`INVALID_FILTER_VALUE`|`107`|
|`COUNT_MISMATCH`|`108`|
|`KEY_ORDER_MISMATCH`|`109`|
|`KEY_NOT_INCLUDED_IN_URL`|`110`|
|`INVALID_INCLUDE`|`112`|
|`RELATION_EXISTS`|`113`|
|`INVALID_SORT_CRITERIA`|`114`|
|`INVALID_LINKS_OBJECT`|`115`|
|`TYPE_MISMATCH`|`116`|
|`INVALID_PAGE_OBJECT`|`117`|
|`INVALID_PAGE_VALUE`|`118`|
|`INVALID_FIELD_FORMAT`|`119`|
|`INVALID_FILTERS_SYNTAX`|`120`|
|`SAVE_FAILED`|`121`|
|`FORBIDDEN`|`403`|
|`RECORD_NOT_FOUND`|`404`|
|`NOT_ACCEPTABLE`| `406`|
|`UNSUPPORTED_MEDIA_TYPE`|`415`|
|`LOCKED`|`423`|
|`INTERNAL_SERVER_ERROR`|`500`|

{% note info %}

На уровне HTTP все ошибки, кроме `FORBIDDEN` и `RECORD_NOT_FOUND`, имеют статус `400`.

{% endnote %}


