# Таски

Запросы позволяют получить список тасков и подробную информацию по любому из них.

#### Список тасков

```
{{ host }}/{{ api-ver }}/tasks
```

Вы можете фильтровать таски по времени создания или изменения с помощью параметра `filter`:

```
{{ host }}/{{ api-ver }}/tasks?filter[created_at]=<дата1>..<дата2>&filter[updated_at]=<дата3>..<дата4>
```

Даты записываются в формате ISO-8601: `YYYY-MM-DD` или `YYYY-MM-DDThh:mm:ss±hh:mm`.

#### Параметры определенного таска

```
{{ host }}/{{ api-ver }}/tasks/<id таска>
```

## Связанные объекты {#section_gjm_wcs_gbb}

#### Идентификатор тикета, к которому относится таск

```
{{ host }}/{{ api-ver }}/tasks/<id таска>/relationships/ticket
```

#### Параметры тикета, к которому относится таск

```
{{ host }}/{{ api-ver }}/tasks/<id таска>/ticket
```

#### Идентификаторы пакетов, выкладывающихся в рамках таска

```
{{ host }}/{{ api-ver }}/tasks/<id таска>/relationships/packages
```

#### Развернутый список пакетов, выкладывающихся в рамках таска

```
{{ host }}/{{ api-ver }}/tasks/<id таска>/packages
```

#### Идентификатор проекта, в рамках которого производилась выкладка

```
{{ host }}/{{ api-ver }}/tasks/<id таска>/relationships/project
```

#### Параметры проекта, в рамках которого производилась выкладка

```
{{ host }}/{{ api-ver }}/tasks/<id таска>/project
```

