# Макросы

{% note alert %}

Процедуры, описанные в разделе, выполняются пользователями с ролью не ниже Musician.

{% endnote %}

Для объединения [групп хостов](groups.md), относящихся к разным [проектам](projects.md), используются _макросы_.

Основные области применения:

- API {{ serviceName }}а — получение списка хостов, относящихся к макросу.
- [Утилита ](../utilities.md){{ executor }} — обход множества хостов одной командой (без перечисления).

Процедуры, выполняемые с макросами:

- [Добавление макроса](#new).
- [Редактирование макроса](#edit).
- [Удаление информации о макросах](#deleting-macro).

## Добавление макроса {#new}

Для регистрации информации о макросе выполните следующие действия:

1. Откройте окно создания записи о макросе (**Макросы** → **Добавить макрос**).
    
1. Заполните поля:
    
    #|
    || **Параметр** | **Описание** ||
    || **Имя** | Название макроса. ||
    || **Описание** | Описание макроса в свободной форме. ||
    || **Теги** | Список ключевых слов, характеризующих макрос.
    
    {% include [new-tags-2-sentence](../_includes/task/repos/id-new/tags-2-sentence.md) %}
    
    {% include [new-task-3-sentence](../_includes/task/repos/id-new/task-3-sentence.md) %}
    
    Значение наследуется всем [хостам](hosts.md), которые входят в [группы](groups.md), назначенные данному макросу. ||
    || **Дочерние макросы** | Список макросов, которые должны входить в данный.
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %}
    
    Могут быть выбраны только макросы, которые определены в {{ serviceName }}е. ||
    || **Группы** | Список групп хостов, которые должны входить в данный макрос.
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %}
    
    Доступны только [группы хостов](groups.md), которые [определены](groups.md) в {{ serviceName }}е. ||
    |#

1. Сохраните изменения (кнопка **Сохранить**).

В результате в {{ serviceName }}е регистрируется информация о макросе. К группам хостов, связанным с зарегистрированным макросом, можно обращаться по названию макроса.

## Редактирование макроса {#edit}

Для редактирования информации о макросе выполните следующие действия:

1. Откройте список доступных макросов (**Макросы**).
1. Выберите макрос из списка. Для ограничения списка отображаемых макросов используйте строку поиска.
1. Внесите изменения в поля формы (см. шаг 2 процедуры [Добавление макроса](#new)).
1. Сохраните изменения (кнопка **Сохранить**).

## Удаление информации о макросах {#deleting-macro}

Для удаления информации о макросе выполните следующие действия:

1. Откройте список доступных макросов (**Макросы**).
1. Выберите макрос из списка. Для ограничения списка отображаемых макросов используйте строку поиска.
1. Нажмите кнопку **Удалить**.
1. Подтвердите намерение удалить информацию о макросе (кнопка **OK**).

В результате выполнения процедуры данные о макросе удаляются из {{ serviceName }}а.
