# Роли по проектам

В зависимости от выполняемых задач, пользователи могут обладать различными ролями в рамках проектов.

## Администраторы проекта {#project-admin}

_Администраторы проекта_ — пользователи, ответственные за проект. Администратор управляет проектом (может изменить или удалить его), а так же связанными с ним объектами:

- [хостами](hosts.md) и [группами хостов](groups.md);
- [воркфлоу](workflows.md);
- [тасками](tickets.md).

По умолчанию правами на администрирование проекта обладают его создатель и пользователи с ролью [Conductor](../access.md#conductor). Другие пользователи могут запросить роль администратора проекта с помощью [IDM](https://idm.yandex-team.ru):

1. Перейдите в [IDM](https://idm.yandex-team.ru). Для доступа к сервису вы должны быть авторизованы во внутреннем [Я.Паспорте](https://passport.yandex-team.ru/).
1. В окне запроса роли (кнопка **Запросить роль**) укажите:
    
    - **Система** — <q>Кондуктор</q>;
    - **Тип ролей** — <q>Роли по проектам</q>;
    - **Проект** — имя проекта в Кондукторе;
    - **Тип ролей внутри проекта** — <q>Роли на весь проект</q>;
    - **Роль внутри проекта** — <q>Администратор проекта</q>.
    
1. Отправьте заявку (кнопка **Запросить**).

## Администраторы группы хостов {#group-admin}

{% include [AddGroupAdmin-group-admin-request](../_includes/task/groups/id-AddGroupAdmin/group-admin-request.md) %}

## Одобряторы {#approver}

Одобряторы — это пользователи, которые участвуют в [одобрении](packages.md#edit_approvers) выкладки на деплой-группы проекта. Администратор проекта может настроить выкладку пакетов так, чтобы без подтверждения одобряторов она была невозможна. [Настройка одобрений](packages.md#edit_approvers) выполняется в свойствах пакета.

{% cut "Как работают одобрения" %}

### Сочетания одобрений

Чтобы ограничить выкладку пакета на деплой-группу, администратор проекта должен задать для нее _сочетание одобрений_ — список одобряторов и минимальное число одобрений для выкладки. Например, для сочетания из четырех одобряторов можно указать минимальное число одобрений <q>3</q>. Возможные результаты проверки такого сочетания приведены на рисунке:

![alt-text](../_images/approvers-combinations.png)

### Комбинации сочетаний

Если для выкладки требуется подтверждение от нескольких независимых групп одобряторов, для деплой-группы можно задать несколько сочетаний одобрений. При этом для выкладки пакета необходимо, чтобы выполнялось каждое из сочетаний. На рисунке показана ситуация, в которой для деплой-группы 1 выкладка разрешена (выполняются все сочетания одобрений), а для деплой-группы 2 выкладка запрещена (одно из сочетаний не выполняется):

![alt-text](../_images/approving-scheme.png)

{% endcut %}

Чтобы запросить роль одобрятора:

1. Перейдите в [IDM](https://idm.yandex-team.ru). Для доступа к сервису вы должны быть авторизованы во внутреннем [Я.Паспорте](https://passport.yandex-team.ru/).
1. В окне запроса роли (кнопка **Запросить роль**) укажите:
    
    - **Система** — <q>Кондуктор</q>;
    - **Тип ролей** — <q>Роли по проектам</q>;
    - **Проект** — имя проекта в Кондукторе;
    - **Тип ролей внутри проекта** — <q>Роли на весь проект</q>;
    - **Роль внутри проекта** — <q>Одобрятор</q>.
