# Проекты

{% include [Projects-ProjectsBasicInfo](../_includes/concepts/package-props/id-Projects/ProjectsBasicInfo.md) %}

{% include [Projects-projects-basic-info-2](../_includes/concepts/package-props/id-Projects/projects-basic-info-2.md) %}

Процедуры, выполняемые с проектами:

- [Добавление проекта](#new).
- [Запрос прав на администрирование проекта](#add-admin).
- [Запрос роли одобрятора проекта](#add_approvers).
- [Редактирование проекта](#edit).
- [Удаление информации о проекте](#DeleteProject).
- [Фильтр тасков проекта](#task-filter).
- [Настройка расписания автовыкладки](#schedule).

## Добавление проекта {#new}

{% note alert %}

Процедура выполняется пользователями с ролью не ниже Musician.

{% endnote %}

Для регистрации информации о проекте выполните следующие действия:

1. Откройте окно создания записи о проекте (**Проекты** → **Добавить проект**).
1. Заполните поля:
    
    #|
    || **Параметр** | **Описание** ||
    || **Имя** | Название проекта. ||
    || **Сервис в ABC** | Идентификатор сервиса, которому соответствует проект.
    
    Должен совпадать с одним из значений в [https://abc.yandex-team.ru/](https://abc.yandex-team.ru/).
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %} ||
    || **Email-рассылка администраторов** | Электронный адрес рассылки и/или администраторов, ответственных за проект.
    
    Значения задаются через запятую, указание домена (`yandex-team.ru`) необязательно. Предусмотрена защита от указания адресов почтовых ящиков в любой другой доменной зоне. ||
    || **Email-рассылка для серверов** | Электронный адрес, используемый вместо указанного в `/etc/aliases` для пользователя `root` на сервере проекта.
    
    Указание домена (`yandex-team.ru`) необязательно. Предусмотрена защита от указания адресов почтовых ящиков в любой другой доменной зоне. ||
    || **Email-рассылка выкладок** | Электронные адреса рассылок и/или администраторов, на которые должны отправляться уведомления о начале и завершении выполнения тасков.
    
    {% include [new-how-to-emails](../_includes/task/projects/id-new/how-to-emails.md) %} ||
    || **Уведомления Cauth** | Электронный адрес рассылки Cauth-уведомлений, которые не требуют ответных действий. Например, сообщения о подтверждении и отзыве доступов.
    
    Если значение не указано, уведомления отправляются на адрес, указанный в поле **Email-рассылка администраторов**. ||
    || **Очередь для запросов Cauth** | Очередь в Стартреке, в которой необходимо заводить задачи на получение доступов и решения проблем с динамическими доступами. Используется CAuth.
    
    Очередь должна быть доступна для робота `cauth-robot-rw@`.
    
    Если значение указано, уведомления на рассылку, указанную в поле **Email-рассылка администраторов**, не отправляются. Вместо этого в указанную очередь ставится задача. ||
    || **Уведомления о Frozen** | Необходимость отправлять [уведомления](../notifications.md) автору [тикета на выкладку](tickets.md) пакета о [статусе](../statuses.md) «Frozen». ||
    || **Описание** | Описание проекта в свободной форме. ||
    || **Теги** | Список ключевых слов, характеризующих проект.
    
    {% include [new-tags-2-sentence](../_includes/task/repos/id-new/tags-2-sentence.md) %}
    
    {% include [new-task-3-sentence](../_includes/task/repos/id-new/task-3-sentence.md) %} ||
    |#

1. Сохраните изменения (кнопка **Сохранить**).

## Запрос прав на администрирование проекта {#add-admin}

{% note alert %}

Процедура выполняется пользователями с ролью не ниже Audience.

{% endnote %}

По умолчанию правами на [администрирование](../access.md) (редактирование и удаление) проекта обладают его создатель и пользователи с ролью [Conductor](../access.md#access_conductor). Другие пользователи могут запросить роль администратора проекта с помощью [IDM](https://idm.yandex-team.ru):

1. Перейдите в [IDM](https://idm.yandex-team.ru). Для доступа к сервису вы должны быть авторизованы во внутреннем [Я.Паспорте](https://passport.yandex-team.ru/).
1. В окне запроса роли (кнопка **Запросить роль**) укажите:
    
    - **Система** — <q>Кондуктор</q>;
    - **Тип ролей** — <q>Роли по проектам</q>;
    - **Проект** — имя проекта в Кондукторе;
    - **Тип ролей внутри проекта** — <q>Роли на весь проект</q>;
    - **Роль внутри проекта** — <q>Администратор проекта</q>.
    
1. Отправьте заявку (кнопка **Запросить**).

В результате будет сформирован запрос на присвоение пользователю роли администратора. Роль будет выдана после того, как запрос одобрит один из действующих администраторов проекта.

## Запрос роли одобрятора проекта {#add_approvers}

{% include [add-admin-audience-restriction1](../_includes/task/projects/id-add-admin/audience-restriction1.md) %}

_Одобряторы_ — пользователи, которые участвуют в [подтверждении](packages.md#edit_approvers) выкладки пакетов на деплой-группы проекта. Вы можете запросить роль одобрятора проекта с помощью [IDM](https://idm.yandex-team.ru):

1. Перейдите в [IDM](https://idm.yandex-team.ru). Для доступа к сервису вы должны быть авторизованы во внутреннем [Я.Паспорте](https://passport.yandex-team.ru/).
1. В окне запроса роли (кнопка **Запросить роль**) укажите:
    
    - **Система** — <q>Кондуктор</q>;
    - **Тип ролей** — <q>Роли по проектам</q>;
    - **Проект** — имя проекта в Кондукторе;
    - **Тип ролей внутри проекта** — <q>Роли на весь проект</q>;
    - **Роль внутри проекта** — <q>Одобрятор</q>.

В результате будет сформирован запрос на присвоение пользователю роли одобрятора. Роль будет выдана после того, как запрос одобрит один из действующих администраторов проекта.

## Редактирование проекта {#edit}

{% note alert %}

Процедура может быть выполнена только администраторами проекта.

{% endnote %}

Для редактирования данных о проекте выполните следующие действия:

1. Откройте список проектов ([Проекты](https://c.yandex-team.ru/projects)) и выберите проект.
1. Перейдите в окно **Редактирование.**
1. Внесите изменения в поля формы (см. шаг 2 процедуры [Добавление проекта](#new)).
1. Сохраните изменения (кнопка **Сохранить**).

## Удаление информации о проекте {#DeleteProject}

{% include [edit-project-admin-restriction1](../_includes/task/projects/id-edit/project-admin-restriction1.md) %}

Для удаления данных о проекте выполните следующие действия:

1. Откройте список проектов ([Проекты](https://c.yandex-team.ru/projects)) и выберите проект.
1. Перейдите в окно **Редактирование.**
1. Нажмите кнопку **Удалить**.
1. Подтвердите намерение удалить информацию о проекте (кнопка **Ок**).

В результате выполнения процедуры информация о проекте удаляется из {{ serviceName }}а.

## Фильтр тасков проекта {#task-filter}

{% include [add-admin-audience-restriction1](../_includes/task/projects/id-add-admin/audience-restriction1.md) %}

Чтобы просмотреть все завершенные [таски](tickets.md), связанные с проектом, воспользуйтесь **Фильтром тасков**. С его помощью вы можете отфильтровать таски по:

- ветке;
- дате выкладки.

Чтобы отфильтровать таски проекта:

1. Откройте список проектов ([Проекты](https://c.yandex-team.ru/projects)) и выберите проект.
1. Перейдите на страницу **Фильтр тасков** и заполните поля:
    
    Поле | Описание
    ----- | -----
    **Ветка** | Ветка, на которую производилась выкладка.
    **Время выкладки** | Интервал времени выкладки в формате `yyyy-mm-dd[ hh:mm:ss]` или `[dd.mm[.yyyy]] [hh:mm[:ss]]`.
    
В результате формируется перечень завершенных тасков на выкладку на хосты заданного проекта.

## Настройка расписания автовыкладки {#schedule}

{% include [edit-project-admin-restriction1](../_includes/task/projects/id-edit/project-admin-restriction1.md) %}

_Расписание автовыкладки_ позволяет задать промежутки времени, в течение которых доступна автоматическая выкладка пакетов на хосты проекта.

Чтобы задать расписание автовыкладки:

1. Откройте список проектов ([Проекты](https://c.yandex-team.ru/projects)) и выберите проект.
1. Перейдите на страницу **Расписание автодеплоя** и укажите:
    
    - [ветки](../branches.md), для которых вы хотите использовать автовыкладку;
    - дни недели, по которым разрешена автовыкладка;
    - интервал времени, в течение которого разрешена автовыкладка.
    
1. Сохраните изменения.

При работе расписания учитывается время **создания** таска:

- Если [таск](tickets.md#new) был создан в то время, когда автовыкладка разрешена, выкладка будет выполнена вне зависимости от ее продолжительности.
- Если таск был создан в то время, когда автовыкладка запрещена, пакеты будут выложены, как только автовыкладка снова станет доступной.
