# Воркфлоу

{% note alert %}

Процедуры, описанные в разделе, могут быть выполнены только администраторами проекта.

{% endnote %}

{% include [workflows-workflow-sentence-1](../_includes/concepts/package-props/id-workflows/workflow-sentence-1.md) %}

{% include [workflows-workflow-sentence-2](../_includes/concepts/package-props/id-workflows/workflow-sentence-2.md) %}

{% include [workflows-workflow-sentence-3](../_includes/concepts/package-props/id-workflows/workflow-sentence-3.md) %}

Процедуры, выполняемые с воркфлоу:

- [Добавление воркфлоу](#new).
- [Редактирование воркфлоу](#edit).
- [Редактирование деплоя](#edit_deploy).
- [Удаление воркфлоу](#delete).

## Добавление воркфлоу {#new}

Для регистрации информации о воркфлоу выполните следующие действия:

1. Откройте окно добавления воркфлоу (**Воркфлоу** → **Добавить воркфлоу**).
1. Заполните поля:
    
    #|
    || **Параметр** | **Описание** ||
    || **Имя** | Название воркфлоу. Должно быть уникальным в рамках [проекта](projects.md).
    
    Используется для связи с пакетом при [настройке](packages.md#new) хостов, на которые необходимо выкладываться. ||
    || **Проект** | Проект, к которому относится воркфлоу.
    
    Ограничивает множество [хостов](hosts.md) и [групп хостов](groups.md) теми, которые связаны с указанным проектом.
    
    Доступны проекты, для которых пользователь определен в качестве [администратора](admin-role.md). ||
    || **Список веток** | Набор [веток](../branches.md), для которых необходимо определить правила выкладки. В рамках данного воркфлоу пакет выкладывается только в перечисленные ветки.
    
    Доступные значения:
    
    - **unstable**
    - **testing**;
    - **prestable**;
    - **stable**.
    
    Должна быть выбрана по крайней мере одна ветка. ||
    |#

    Множество деплой-групп для выбранных веток. Каждой ветке может быть назначено неограниченное количество деплой-групп.
    
    #|
    || **добавить деплой-группу** | Название деплой-группы (списка хостов, на которые необходимо выложить пакет).
    
    Должно быть уникальным в рамках воркфлоу. ||
    || **автовыкладка** | Включить автовыкладку для заданной деплой-группы. ||
    || **добавить группу или хост** | Список хостов или групп хостов, на которые необходимо выкладывать пакет в рамках деплой-группы в данной ветке.
    
    Значения должны быть определены в {{ serviceName }}е. При введении отображается форма автозаполнения.
    
    Для указания группы хостов необходимо в начале строки указать символ <q>%</q>. Например, чтобы задать группу `iron-man-group`, следует указать значение <q>%iron-man-group</q>.
    
    Доступны только [хосты](hosts.md), которые относятся к [группам](groups.md) тех [проектов](groups.md#project), для которых пользователь определен в качестве администратора. ||
    |#

1. Вы можете установить порядок выкладки на деплой-группы. Если порядок установлен, выкладка пакета на следующую деплой-группу невозможна, пока не завершена выкладка на предыдущую.
    
    Чтобы задать порядок выберите деплой-группу, нажмите кнопку ![alt-text](../_images/b-deploy-list-connection.png) и укажите на следующую деплой-группу. Между упорядоченными группами будет установлена связь, которая отображается в интерфейсе в виде стрелки.

    {% note info %}
    
    К одной деплой-группе может вести несколько стрелок. Для выкладки пакета на такую группу, необходимо успешное завершение выкладки хотя бы на одну из предыдущих.
    
    {% endnote %}
    
    Если установленный порядок не подходит для некоторых пакетов, связанных с воркфлоу, вы можете настроить для таких пакетов [особенности выкладки](packages.md#edit_properties).

1. Сохраните изменения.

В результате в {{ serviceName }}е регистрируется информация о воркфлоу, который может быть привязан к [пакетам](packages.md).

## Редактирование воркфлоу {#edit}

Для редактирования данных о воркфлоу выполните следующие действия:

1. Откройте список доступных воркфлоу (**Воркфлоу**).
1. Выберите воркфлоу из списка и нажмите кнопку **Редактирование**.
1. Внесите изменения в поля формы (см. шаг 2 процедуры [Добавление воркфлоу](#new)).
1. Сохраните изменения (кнопка **Сохранить**).

## Редактирование деплоя {#edit_deploy}

_Деплоем_ называют перечень пакетов, при выкладке которых применяется воркфлоу. Вы можете добавить в деплой любое количество пакетов.

Добавление пакета в деплой воркфлоу и добавление воркфлоу в [деплой-лист](packages.md) пакета — равнозначные действия. Обе процедуры устанавливают связь между пакетом и воркфлоу.

Чтобы отредактировать деплой:

1. Откройте список доступных воркфлоу (**Воркфлоу**).
1. Выберите воркфлоу из списка и нажмите кнопку **Редактировать деплой**.
1. Заполните поля:
    
    #|
    || **Параметр** | **Описание** ||
    || **Копировать деплой** | Название воркфлоу (или группы воркфлоу), из которого нужно скопировать деплой (список пакетов, которые должны выкладываться в соответствии с правилами).
    
    Должен соответствовать одному из значений, зарегистрированных в {{ serviceName }}е.
    
    {% include [new-autocomplete](../_includes/task/hosts/id-new/autocomplete.md) %} ||
    || **Переместить пакеты этого ↑ воркфлоу (или группы) в текущий** | Перенести в текущий воркфлоу список пакетов, определенных для указанного в поле **Копировать деплой**.
    
    Если опция выбрана, после сохранения пакеты отвязываются от выбранного воркфлоу и привязываются к текущему. ||
    || **Блок Пакеты** | Список пакетов, которые необходимо выкладывать в соответствии с текущим воркфлоу.
    
    Возможные действия с пакетами:
    
    - Добавить. Введите название в поле (справа от списка) и выберите нужно значение. Выбранные пакеты отмечается символом ![alt-text](../_images/b-checked.png).
    - Удалить. Выберите пакет из списка нажмите кнопку ![alt-text](../_images/b-delete.png). ||
    |#

1. Сохраните изменения (кнопка **Сохранить**).

В результате выполнения процедуры изменяется список пакетов, которые должны устанавливаться по текущему воркфлоу.

## Удаление воркфлоу {#delete}

Чтобы удалить воркфлоу выполните следующие действия:

1. Откройте список доступных воркфлоу (**Воркфлоу**).
1. Выберите воркфлоу из списка и нажмите кнопку **Редактирование**.
1. Нажмите кнопку **Удалить**.
1. Подтвердите намерение удалить информацию о воркфлоу (кнопка **ОК**).

В результате выполнения процедуры из {{ serviceName }}а удаляется информация о воркфлоу. Связь с пакетами, завязанными на данный воркфлоу, разрывается.
