"""
Conductor mysql status check.

"""
from infra.rtc.juggler.bundle.util import get_file_content, get_process_info
from juggler.bundles import as_check, Status, Event as JugglerEvent

import MySQLdb
import MySQLdb.cursors as cursors
import re

CHECK_NAME = 'conductor-mysql-master'
GLOBAL_TAGS = ['CONDUCTOR-2019']  # this check involved in monitoring coverage
MHOST = '127.0.0.1'
MPORT = 3306
LDATA = 'monitor'
DB = 'information_schema'

class Event(JugglerEvent):
    def __init__(self, *args, tags=None, **kwargs):
        tags = GLOBAL_TAGS if tags is None else tags + GLOBAL_TAGS
        super().__init__(*args, tags=tags, **kwargs)

@as_check(name=CHECK_NAME)
def juggler_check():
    try:
        connection = MySQLdb.connect(host=MHOST,
                                     port=MPORT,
                                     user=LDATA,
                                     passwd=LDATA,
                                     db=DB,
                                     cursorclass=cursors.DictCursor)
    except Exception as e:
        return Event(Status.CRIT, str(e))

    cursor = connection.cursor()

    try:
        cursor.execute("SELECT COUNT(1) SlaveThreadCount FROM information_schema.processlist WHERE user='system user';")
    except Exception as e:
        return Event(Status.CRIT, str(e))

    row = cursor.fetchone()
    if row['SlaveThreadCount'] != 0:
        return Event(Status.OK, 'I am the slave(')

    try:
        cursor.execute("SHOW MASTER STATUS")
    except Exception as e:
        return Event(Status.CRIT, str(e))

    row = cursor.fetchone()

    if re.match('mysql\-[0-9]{1,5}-bin\.[0-9]+', row['File']) and re.match('^[0-9]+$', str(row['Position'])):
        return Event(Status.OK, 'Master is OK!')
    else:
        return Event(Status.CRIT, 'Something strange happened with the master!')
