import fcntl
import socket


def set_close_exec(fd):
    """
    Helper to add CLOEXEC to provided file descriptor.
    :type fd: int
    """
    flags = fcntl.fcntl(fd, fcntl.F_GETFD)
    fcntl.fcntl(fd, fcntl.F_SETFD, flags | fcntl.FD_CLOEXEC)


def create_server_socket(host, port, backlog=100):
    """
    Try to create ipv6 socket, start listening on it.

    :returns: listening socket
    """
    if host == '0.0.0.0':
        host = ''
    try:
        sock = socket.socket(socket.AF_INET6)
    except EnvironmentError as e:
        return None, "failed to create ipv6 socket: {0}".format(e.strerror)
    sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    sock.setblocking(0)
    # mark the socket fd as non-inheritable
    set_close_exec(sock.fileno())
    try:
        sock.bind((host, port))
    except socket.error as e:
        # it's useful to log what host and port we failed to bind
        return None, "failed to bind [{}]:{}: {}".format(host, port, e)
    sock.listen(backlog)
    return sock, None
