#!/usr/bin/env python
# -*- coding: utf-8 -*-
import argparse
import mimetypes

from infra.cores.app import background_thread
from infra.cores.app import create_app


parser = argparse.ArgumentParser()
parser.add_argument("-p", "--port", help="Port number", required=True)


def main():
    mimetypes.add_type('application/font-woff2', '.woff2')
    args = parser.parse_args()

    app_flask = create_app(background_thread.BackgroundThread)

    from infra.cores.app import views  # noqa
    views.init_routes(app_flask)

    app_flask.run(debug=True, host="::", port=int(args.port or 80))


if __name__ == "__main__":
    main()
