import os
import library.python.flask as lpf
import library.python.resource as lpr
from flask import Flask
import jinja2
from flask_sqlalchemy import SQLAlchemy
from flask_bootstrap import Bootstrap
import sys
import signal


db = SQLAlchemy()
bootstrap = Bootstrap()


def create_app(background_thread_class):
    app_flask = Flask(
        __name__,
        template_folder=None,
        static_folder=None,
    )
    app_flask.secret_key = "some_secret"
    app_flask.config.from_object('infra.cores.config.default')
    app_flask.config['SQLALCHEMY_ECHO'] = True
    app_flask.config['SQLALCHEMY_TRACK_MODIFICATIONS'] = True
    app_flask.config["SQLALCHEMY_RECORD_QUERIES"] = False
    app_flask.config["SQLALCHEMY_POOL_RECYCLE"] = 120
    lpf.serve_static_data_from_resources(
        app_flask,
        prefix='/static/',
        resource_prefix='/app/static/',
    )
    app_flask.root_path = os.path.join(app_flask.config['BASE_DIR'], 'app')
    app_flask.static_url_path = '/static/'
    app_flask.jinja_loader = jinja2.DictLoader(
        {
            key: value.decode('utf-8')
            for key, value in
            lpr.iteritems(
                prefix='/app/templates/',
                strip_prefix=True,
            )
        }
    )

    db.init_app(app_flask)
    bootstrap.init_app(app_flask)

    background_thread = background_thread_class(app_flask)

    def kill_handler(signal, frame):
        app_flask.logger.info('CTRL-C pressed!')
        background_thread.killed = True
        sys.exit(0)

    signal.signal(signal.SIGINT, kill_handler)

    def background_thread_start():
        # Do initialisation stuff here
        # global BackgroundThread
        # Create your thread
        background_thread.start()

    # Initiate
    background_thread_start()

    return app_flask
