import time
import traceback

from threading import Thread

from infra.cores.app import models
from infra.cores.app import helpers
from infra.cores.app import garbage_collector


def background_thread_tick(app_flask, invocation_time):
    """Main guts of thread extracted to separate method to allow testing."""

    exception_text = None

    try:
        with app_flask.app_context():
            garbage_collector.cleanup_obsolete_cores(app_flask)

        with app_flask.app_context():
            if invocation_time % 20 == 0:
                app_flask.suggest_cache = helpers.get_items_for_main_table_suggest(models.Core.query)

        return (True, None)  # continue thread

    except KeyboardInterrupt:
        app_flask.logger.info("Got KeyboardInterrupt, breaking")
        return (False, 'KeyboardInterrupt')

    except Exception as exc:
        app_flask.logger.exception("[BackgroundThread] Exception %s", str(exc))
        exception_text = traceback.format_exc()

    return (False, exception_text)


class BackgroundThread(Thread):
    def __init__(self, app_flask):
        self.invocation_time = -1
        self.killed = False
        self.app_flask = app_flask
        self.app_flask.suggest_cache = {}
        super(BackgroundThread, self).__init__()

    def run(self):
        while not self.killed:
            self.invocation_time += 1

            if self.invocation_time % 5 != 0:
                time.sleep(3)
                continue

            continue_flag, _ = background_thread_tick(self.app_flask, self.invocation_time)
            if not continue_flag:
                break

        self.app_flask.logger.info("[BackgroundThread] Got kill signal [killed: %s]", self.killed)
