import copy
import logging

import flask

from infra.cores.app import const


def parse_show_fixed(args):
    show_fixed = args[const.FILTER].get("show_fixed", False)
    if not isinstance(show_fixed, bool):
        show_fixed = "True" if show_fixed else False
    return show_fixed


def update_dict(args_old, args_new, cur_cat):
    logging.info("ARGS_NEW: %s\nARGS_OLD: %s", args_new, args_old)
    result = args_old

    for cat in [const.FILTER, cur_cat]:
        for key in const.args_default[cat]:
            if key in args_new:
                result[cat][key] = args_new[key]
            else:
                if key not in args_old[cat]:
                    result[cat][key] = const.args_default[cat][key]
    result[const.FILTER]["show_fixed"] = parse_show_fixed(result)
    logging.info("RESULT: %s", result)
    return result


def custom_url_for(cur_cat=const.MAIN, args_new=None, page="", **kwargs):
    if not args_new:
        context = {cur_cat: {}, const.FILTER: {}}
    else:
        context = copy.deepcopy(args_new)
    for key in kwargs:
        if key in context[cur_cat]:
            context[cur_cat][key] = kwargs[key]
        elif key in context[const.FILTER]:
            context[const.FILTER][key] = kwargs[key]
    new_context = context[cur_cat]
    new_context.update(context[const.FILTER])
    if page.startswith('/'):
        page = page[1:]
    return flask.url_for(page, **new_context)
