import os

LIMIT_PER_PAGE = 10
SECONDS_IN_MINUTE = 60
SECONDS_IN_HOUR = SECONDS_IN_MINUTE * 60
SECONDS_IN_DAY = SECONDS_IN_HOUR * 24
SECONDS_IN_MONTH = SECONDS_IN_DAY * 30
SECONDS_IN_YEAR = SECONDS_IN_DAY * 365
MAX_SAME_CORES_PER_HOUR = 3
SAME_CORES_INTERVAL = 4 * 3600  # 4 hours

# Page names
MAIN_URL = ""
INDEX = "index"
CLEAR_ALL_FILTERS = "clear_all_filters"
CORE = "core"
CORE_TRACE = "core_trace"
EXTEND_CORE_TTL = "extend_core_ttl"
MARK_AS_FIXED = "mark_as_fixed"
CREATE_TICKET = "create_ticket"
SUBMIT_CORE = "submit_core"
DEFAULT_CORES = "default_cores"
ADD_CORE_TYPE = "add_core_type"
LINK_TICKET = "link_ticket"
DELETE_TICKET_LINK = "delete_ticket_link"
REMOVE_CORE_TYPE = "remove_core_type"
USER_SETTINGS = "user_settings"
USER_CORES = "user_cores"
SANDBOX = "sandbox"
CORE_DETAILS = "api/core_details"
CORE_LIST_IDS = "api/core_list"
CORE_INFO = "api/core"


MAIN = "main"
DEVELOPER_LOGIN = "glebov-da"
SORT = "sort"
FILTER = "filter"
SINGLE = "single"
CUR_CAT = "cur_cat"
STARTREK_KEY_FOR_CORES = "startrek_key_for_cores"
ARCADIA_ROOT_LINK = "https://a.yandex-team.ru/arc/trunk/arcadia/"
DEFAULT_HOST = "https://coredumps.yandex-team.ru/"

arcadia_root_dirs = [
    "/lib/x86_64-linux-gnu/",
    "/aapi/",
    "/addappter/",
    "/adfox/",
    "/admins/",
    "/ads/",
    "/advq/",
    "/afisha/",
    "/alet/",
    "/alice/",
    "/analytics/",
    "/antiadblock/",
    "/antirobot/",
    "/april/",
    "/arc/",
    "/arcanum/",
    "/augur/",
    "/aurora/",
    "/autocheck/",
    "/balancer/",
    "/bass/",
    "/bigb/",
    "/billing/",
    "/bindings/",
    "/browser/",
    "/build/",
    "/bunker/",
    "/caas/",
    "/canvas/",
    "/captcha/",
    "/catboost/",
    "/certs/",
    "/client_analytics/",
    "/cloud/",
    "/cmicot/",
    "/cmnt/",
    "/comdep_analytics/",
    "/contrib/",
    "/crypta/",
    "/cv/",
    "/devtools/",
    "/dict/",
    "/direct/",
    "/disk/",
    "/distribution/",
    "/distribution_interface/",
    "/district/",
    "/dj/",
    "/docs/",
    "/edadeal/",
    "/entity/",
    "/extdata/",
    "/extsearch/",
    "/FactExtract/",
    "/fintech/",
    "/fuzzing/",
    "/games/",
    "/gencfg/",
    "/geoadv/",
    "/geobase/",
    "/glycine/",
    "/groups/",
    "/haas/",
    "/health/",
    "/hitman/",
    "/home/",
    "/htf/",
    "/hw_watcher/",
    "/hypercube/",
    "/iaas/",
    "/iceberg/",
    "/infra/",
    "/intranet/",
    "/inventori/",
    "/ipreg/",
    "/jdk/",
    "/juggler/",
    "/junk/",
    "/jupytercloud/",
    "/kernel/",
    "/keyboard/",
    "/kikimr/",
    "/kinopoisk/",
    "/laas/",
    "/lbs/",
    "/library/",
    "/load/",
    "/locdoc/",
    "/logbroker/",
    "/logfeller/",
    "/mail/",
    "/mapreduce/",
    "/maps/",
    "/market/",
    "/mb/",
    "/mds/",
    "/media/",
    "/mediaplanner/",
    "/metrika/",
    "/ml/",
    "/mlp/",
    "/modadvert/",
    "/mssngr/",
    "/music/",
    "/netsys/",
    "/nginx/",
    "/nirvana/",
    "/noc/",
    "/ofd/",
    "/opensource/",
    "/orgvisits/",
    "/original/",
    "/packages/",
    "/partner/",
    "/passport/",
    "/paysys/",
    "/portal/",
    "/quality/",
    "/quasar/",
    "/razladki/",
    "/regulargeo/",
    "/release_machine/",
    "/rem/",
    "/rnd_toolbox/",
    "/robot/",
    "/rtc/",
    "/rtline/",
    "/rtmapreduce/",
    "/rt-research/",
    "/saas/",
    "/samogon/",
    "/sandbox/",
    "/scarab/",
    "/scarab2/",
    "/search/",
    "/security/",
    "/serp/",
    "/sitesearch/",
    "/skynet/",
    "/smm/",
    "/solomon/",
    "/specsearches/",
    "/sprav/",
    "/statbox/",
    "/strm/",
    "/sup/",
    "/switch/",
    "/tasklet/",
    "/taxi/",
    "/taxi_efficiency/",
    "/testenv/",
    "/testpalm/",
    "/testpers/",
    "/tools/",
    "/tracker/",
    "/traffic/",
    "/transfer_manager/",
    "/travel/",
    "/trust/",
    "/util/",
    "/vcs/",
    "/velocity/",
    "/vendor/",
    "/voicetech/",
    "/weather/",
    "/web/",
    "/wmconsole/",
    "/ws/",
    "/xmlsearch/",
    "/yabs/",
    "/yaphone/",
    "/ydf/",
    "/ydo/",
    "/yp/",
    "/yql/",
    "/ysite/",
    "/yt/",
    "/yt_doc/",
    "/yweb/",
    "/zen/",
    "/zootopia/",
    "/zora/",
]


class ChatNotificationConfig(object):
    def __init__(self, chat_id, only_new_cores=False):
        self.chat_id = chat_id
        self.only_new_cores = only_new_cores


CHATS = {
    "basesearch": ChatNotificationConfig(-1001188098685),
    "noapacheupper": ChatNotificationConfig(-1001129063068),
    "src_setup": ChatNotificationConfig(-1001310632991),
    "antirobot": ChatNotificationConfig(-1001474691179),
    "smart-captcha": ChatNotificationConfig(-1001474691179),
    "app_host": ChatNotificationConfig(-1001186175788),
    "app_host_http_adapter": ChatNotificationConfig(-1001186175788),
    "app_host_push_client": ChatNotificationConfig(-1001186175788),
    "app_host_horizon_agent": ChatNotificationConfig(-1001186175788),
    "app_host_resolver": ChatNotificationConfig(-1001186175788),
    "market_rtmodels": ChatNotificationConfig(-511003436),
    "mmetasearch": ChatNotificationConfig(-1001570275709),
    "mmeta": ChatNotificationConfig(-1001570275709),
    "itditp-mmeta": ChatNotificationConfig(-1001570275709),
    "crypta-cm": ChatNotificationConfig(-1001178110852),
    "mssngr_balancer": ChatNotificationConfig(-1001447650887),
    "mssngr_worker": ChatNotificationConfig(-1001447650887),
    "intl1": ChatNotificationConfig(-1001570275709),
    "balancer": ChatNotificationConfig(-1001281224443),
    "serpsummarizer": ChatNotificationConfig(-1001469688163),
    "testenv": ChatNotificationConfig(-1001413143123, only_new_cores=True),
    "scraperoveryt_hahn": ChatNotificationConfig(-1001343713545),
    "scraperoveryt_arnold": ChatNotificationConfig(-1001343713545),
    "entitysearch": ChatNotificationConfig(-1001350884635),
    "deploy.production_pbmt_iva.pbmt_workload": ChatNotificationConfig(-1001499067502),
    "deploy.production_pbmt_man.pbmt_workload": ChatNotificationConfig(-1001499067502),
    "deploy.production_pbmt_myt.pbmt_workload": ChatNotificationConfig(-1001499067502),
    "deploy.production_pbmt_sas.pbmt_workload": ChatNotificationConfig(-1001499067502),
    "models_proxy": ChatNotificationConfig(-1001408155119),
    "ydo-searchproxy": ChatNotificationConfig(-1001159257292),
    "yp_dns": ChatNotificationConfig(-1001264411310),
    "yp_service_discovery": ChatNotificationConfig(-1001264411310),
    "uniproxy2": ChatNotificationConfig(-1001664835936),
    "user-sessions-rt-prestable": ChatNotificationConfig(-1001449196292),
    "user-sessions-rt-prestable-ab": ChatNotificationConfig(-1001449196292),
    "user-sessions-rt-prestable-zero": ChatNotificationConfig(-1001449196292),
    "user-sessions-rt-hamster": ChatNotificationConfig(-1001449196292),
    "user-sessions-rt": ChatNotificationConfig(-1001449196292),
    "request_init": ChatNotificationConfig(-1001175598947),
    "mt_prod": ChatNotificationConfig(-1001499067502),
    "mtdbrowser_prod": ChatNotificationConfig(-1001499067502),
    "yabs_rtmodels": ChatNotificationConfig(-1001528404582),
    "rsya_hit_models_heavy_01": ChatNotificationConfig(-1001470867111),
    "rsya_hit_models_light_01": ChatNotificationConfig(-1001470867111),
}

# itype -> queue name
STARTREK_QUEUES = {
    "antirobot": "CAPTCHA",
    "smart-captcha": "CAPTCHA",

    "apphost": "APPHOST",
    "app_host": "APPHOST",  # bogus itype (deprecated)
    "app_host_resolver": "APPHOST",
    "app_host_push_client": "APPHOST",
    "app_host_horizon_agent": "APPHOST",

    "mssngr_balancer": "MSSNGRBACKEND",
    "mssngr_worker": "MSSNGRBACKEND",
    "cmnt-worker-alpha": "CMNT",
    "cmnt-worker-testing": "CMNT",
    "cmnt-api-alpha": "CMNT",
    "cmnt-api-testing": "CMNT",
    "cmnt-worker-prod": "CMNT",

    "balancer": "BALANCER",

    "base": 'SEARCH',
    "mmeta": 'MIDDLE',
    "noapache": 'NOAPACHE',
}

SIG_NUM_TO_SIG_NAME = {  # TODO: use signal library instead of this constants
    "1": "SIGHUP",
    "2": "SIGINT",
    "3": "SIGQUIT",
    "4": "SIGILL",
    "5": "SIGTRAP",
    "6": "SIGABRT",
    "7": "SIGBUS",
    "8": "SIGFPE",
    "9": "SIGKILL",
    "10": "SIGUSR1",
    "11": "SIGSEGV",
    "12": "SIGUSR2",
    "13": "SIGPIPE",
    "14": "SIGALRM",
    "15": "SIGTERM",
    "18": "SIGCHLD",
    "19": "SIGCONT",
    "20": "SIGTSTP",
    "21": "SIGURG",
    "22": "SIGTTOU",
    "23": "SIGSTOP",
    "25": "SIGXFSZ",
    "26": "SIGTTIN",
    "28": "SIGVTALRM",
    "29": "SIGPROF",
    "30": "SIGXCPU",
    "31": "SIGSYS",
}

SIG_NAME_TO_SIG_NUM = {val: key for key, val in SIG_NUM_TO_SIG_NAME.items()}

args_default = dict()
args_default[FILTER] = {
    "signal": "",
    "itype": "",
    "first_time": "",
    "last_time": "",
    "instance": "",
    "timestamp": "",
    "ctype_list": "",
    "host_list": "",
    "tag_list": "",
    "prj_list": "",
    "period": "all",
    "text_to_search": "",
    "show_fixed": False,
}
args_default[MAIN] = {
    "p": 1,
    "direction": "desc",
    "sort": "last_time",
    "ctype_list": "",
    "count": "",
}

args_default[SINGLE] = {
    "p": 1,
    "direction": "desc",
    "sort": "timestamp",
    "core_hash": "",
    "itype": "",
    "ctype": "",
    "prj": "",
    "instance": "",
    "period": "all",
    "first_time": "",
    "last_time": "",
    "tags": "",
}

args_default[CORE_TRACE] = {
    "core_id": "",
}

args_default[CUR_CAT] = MAIN

BOT_TOKEN = os.environ.get("BOT_TOKEN")
VAULT_VERSION = "ver-01fhzfr4mqr3ht76hz4y0a8zdj"
MESSAGE_QUEUE = dict()
BLOCK = dict()
TIME_INTERVAL = 10 * 60
COUNT_INTERVAL = 15
DELAY = 2 * 60 * 60
