import logging

from sqlalchemy import orm

from infra.cores.app import models


def get_filtered_cores_details(
    itype=None,
    tags=None,
    ctype=None,
    prj=None,
    first_time=None,
    last_time=None,
    columns=tuple(),
):
    filters = []
    if itype:
        filters.append(models.CoreDetails.itype == itype)
    if tags:
        for tag in tags:
            filters.append(models.CoreDetails.tags.contains(tag))
    if ctype:
        filters.append(models.CoreDetails.ctype == ctype)
    if prj:
        filters.append(models.CoreDetails.prj == prj)
    if None not in (first_time, last_time):
        filters.append(models.CoreDetails.timestamp.between(first_time, last_time))

    if not filters:
        logging.error('Skip request to filter')
        return None

    filtered_cores = models.CoreDetails.query.filter(
        *filters
    ).options(orm.load_only(*columns)).all()

    return filtered_cores


def get_core_ids_for_tags_filter(tags, request_tags_argument):
    tag_ids = [
        tag[0] for tag in models.TagNames.query.with_entities(
            models.TagNames.tag_id,
        ).filter(models.TagNames.tag_name.in_(tags)).all()
    ]
    core_ids_query = models.CoreTag.query.with_entities(models.CoreTag.core_id).filter(
        models.CoreTag.tag_id.in_(tag_ids)
    ).all()
    if "," in request_tags_argument:
        # We should look for cores which have all of these tags
        core_ids_to_suggest = []
        tag_ids = set(tag_ids)
        for core_id in core_ids_query:
            tag_ids_for_core = [
                tag_id[0] for tag_id in models.CoreTag.query.with_entities(models.CoreTag.tag_id).filter(
                    models.CoreTag.core_id == core_id
                ).all()
            ]
            logging.debug("Tag_ids_query %s", tag_ids_for_core)
            if tag_ids.issubset(tag_ids_for_core):
                core_ids_to_suggest.append(core_id)
        return list(set(core_ids_to_suggest))
    else:
        # We should look for cores which have any of these tags
        return list(set([core_id[0] for core_id in core_ids_query]))
