import logging

from infra.cores.app import db
from infra.cores.app import date_time
from infra.cores.app import models
from infra.cores.app import const


def calculate_expire_time(core_hash, itype, timestamp):
    same_cores_count = models.CoreDetails.query.filter(
        models.CoreDetails.core_hash == core_hash,
        models.CoreDetails.itype == itype,
        models.CoreDetails.timestamp + const.SECONDS_IN_DAY >= timestamp,
    ).count()
    logging.debug("Got %s cores with itype %s and hash %s at last day", same_cores_count, itype, core_hash)
    # We don't want to have more than 2000 cores for month with same hash and itype.
    ttl_days = max(1, min(30, int(2000 / max(1, same_cores_count))))
    logging.debug("TTL for this core is %s days", ttl_days)
    expire_time = ttl_days * const.SECONDS_IN_DAY + timestamp
    return expire_time


def update_expire_time(core_id, core_ttl_update):
    query = models.CoreDetails.query.filter(models.CoreDetails.core_id == core_id).first()
    query.expire_time += core_ttl_update * const.SECONDS_IN_DAY
    db.session.commit()


def cleanup_obsolete_cores(app_flask):
    current_time = date_time.icurrent()
    logging.debug('[cleanup_obsolete_cores] Deleting cores with expire time < %s', current_time)
    core_details_to_delete = models.CoreDetails.query.with_entities(
        models.CoreDetails.core_id,
    ).filter(
        models.CoreDetails.expire_time < current_time,
    ).limit(200).all()

    if not core_details_to_delete:
        return

    row_ids_to_delete = [item.core_id for item in core_details_to_delete]
    logging.debug("[cleanup_obsolete_cores] Deleting core_id`s: %s", ",".join(map(str, row_ids_to_delete)))
    delete_query = models.CoreDetails.__table__.delete().where(
        models.CoreDetails.core_id.in_(row_ids_to_delete)
    )
    db.session.execute(delete_query)
    db.session.commit()
    logging.debug("[cleanup_obsolete_cores] GC done")
