from infra.cores.app import db


class Core(db.Model):
    __tablename__ = 'core'
    core_hash = db.Column(db.BigInteger, primary_key=True, index=True)
    core_summary = db.Column(db.String)
    core_summary_raw = db.Column(db.String)
    itype = db.Column(db.String, primary_key=True, index=True)
    signal = db.Column(db.String(64))
    count = db.Column(db.Integer)
    first_time = db.Column(db.Integer)
    last_time = db.Column(db.Integer, index=True)
    prj_list = db.Column(db.String)
    ctype_list = db.Column(db.String)
    host_list = db.Column(db.String)
    tag_list = db.Column(db.String)
    fixed = db.Column(db.Boolean, index=True)
    tickets = db.Column(db.String)
    last_core_id = db.Column(db.Integer)
    core_details = db.relationship(
        "CoreDetails",
        backref='core',
        lazy='dynamic',
        primaryjoin="and_(Core.core_hash==CoreDetails.core_hash, Core.itype==CoreDetails.itype)",
    )


class CoreDetails(db.Model):
    __tablename__ = 'core_details'
    core_id = db.Column(db.Integer, primary_key=True, index=True, autoincrement=True)
    core_hash = db.Column(db.BigInteger, db.ForeignKey("core.core_hash"), index=True, nullable=False)
    top_frame = db.Column(db.String)
    top_frame_raw = db.Column(db.String)
    instance = db.Column(db.String(64))
    itype = db.Column(db.String(64), index=True)
    ctype = db.Column(db.String(64), index=True)
    prj = db.Column(db.String, index=True)
    tags = db.Column(db.String)
    signal = db.Column(db.String)
    parse_error = db.Column(db.String)
    sb_build = db.Column(db.String(64), nullable=True)
    sb_task_run = db.Column(db.String(64), nullable=True)
    timestamp = db.Column(db.Integer)
    tickets = db.Column(db.String)
    old_cores = db.Column(db.Boolean)
    expire_time = db.Column(db.Integer, index=True)


class CoreSingle(db.Model):
    __tablename__ = "core_single"
    core_id = db.Column(
        db.Integer,
        db.ForeignKey("core_details.core_id", ondelete="CASCADE"),
        primary_key=True,
        index=True,
    )
    full_trace = db.Column(db.String)
    full_trace_raw = db.Column(db.String)
    error = db.Column(db.Boolean)
    additional_text = db.Column(db.String)


class UserInfo(db.Model):
    __tablename__ = "user_info"
    id = db.Column(db.Integer, primary_key=True, index=True, autoincrement=True)
    user_name = db.Column(db.String)
    itype = db.Column(db.String)
    ctype = db.Column(db.String)
    prj = db.Column(db.String)
    tag = db.Column(db.String)


class UserRequestAttributes(db.Model):
    __tablename__ = "user_request_attributes"
    id = db.Column(db.Integer, primary_key=True, index=True, autoincrement=True)
    user_name = db.Column(db.String, index=True)
    page_name = db.Column(db.String, index=True)
    attrs = db.Column(db.JSON)


class TagNames(db.Model):
    __tablename__ = "tag_names"
    tag_id = db.Column(db.Integer, primary_key=True, index=True, autoincrement=True)
    tag_name = db.Column(db.String, index=True)


class CoreTag(db.Model):
    __tablename__ = "core_tag"
    id = db.Column(db.Integer, primary_key=True, index=True, autoincrement=True)
    tag_id = db.Column(db.Integer, db.ForeignKey("tag_names.tag_id"), index=True)
    core_id = db.Column(db.Integer, db.ForeignKey("core_details.core_id", ondelete="CASCADE"), index=True)


class AbcServices(db.Model):
    __tablename__ = "abc_services"
    id = db.Column(db.Integer, primary_key=True, index=True, autoincrement=True)
    group_id = db.Column(db.Integer, index=True)
    group_name = db.Column(db.String, index=True)


class AbcServiceCore(db.Model):
    __tablename__ = "abc_service_core"
    id = db.Column(db.Integer, primary_key=True, index=True, autoincrement=True)
    core_id = db.Column(db.Integer, db.ForeignKey("core_details.core_id"), index=True)
    abc_service_id = db.Column(db.Integer, db.ForeignKey("abc_services.id"), index=True)
