function copySshCommand(element_name) {
    var command = document.getElementById(element_name);
    command.select();
    document.execCommand("copy");
    alert("Copied the text: " + command.value);
}

function confirmDeleteTicketLink(ticket_key, core_id) {
    var delete_link = confirm(`Want to delete link between core and ticket ${ticket_key}?`);
    if (delete_link) {
        $(`#delete_ticket_link_${ticket_key}_${core_id}`).submit();
    }
}

function setAppropriateWidth(element, values) {
    var max_length = Math.max.apply(null, Array.from(values, x => x.length));
    element.style.width = (max_length + 2) + "em";
}

function autocomplete(input_field, values, allow_many=false) {
    var currentFocus;
    input_field.addEventListener("input", dropdown );
    input_field.addEventListener("keydown", function(e) {
        var x = document.getElementById(this.id + "autocomplete-list");
        if (x) {
            x = x.getElementsByTagName("div");
        }
        if (e.keyCode == 40) { // down
            console.log(x)
            if (!x) {
                var a, b, i, val = this.value;

                console.log("Untrimmed val" + val);
                if (allow_many) {
                    current_val = val.split(/,|\|/).slice(-1)[0].trim();
                    console.log("Trimmed val" + current_val);
                } else {
                    current_val = val;
                }

                closeAllLists();
                currentFocus = -1;
                a = document.createElement("DIV");
                a.setAttribute("id", this.id + "autocomplete-list");
                a.setAttribute("class", "autocomplete-items");
                setAppropriateWidth(a, values);
                this.parentNode.appendChild(a);
                var autocomplete_size = 0;
                for (i = 0; i < values.length; i++) {
                    var substring_index = values[i].toUpperCase().indexOf(current_val.toUpperCase());
                    if (substring_index > -1 || current_val == "") {
                        b = document.createElement("DIV");
                        b.innerHTML = values[i].substr(0, substring_index);
                        b.innerHTML += "<strong>" + values[i].substr(substring_index, substring_index + current_val.length) + "</strong>";
                        b.innerHTML += values[i].substr(substring_index + current_val.length);
                        b.innerHTML += "<input type='hidden' value='" + values[i] + "'>";
                        b.addEventListener("click", function(e) {
                            input_field.value = val.substring(0, val.length - current_val.length) + this.getElementsByTagName("input")[0].value;
                            input_field.form.submit();
                            closeAllLists();
                        });
                        a.appendChild(b);
                        autocomplete_size += 1;
                        if (autocomplete_size >= 100) {
                            break;
                        }
                    }
                }
                var x = document.getElementById(this.id + "autocomplete-list");
                if (x) {
                    x = x.getElementsByTagName("div");
                }
            }
            currentFocus++;
            addActive(x);
        } else if (e.keyCode == 38) { // up
            currentFocus--;
            addActive(x);
        } else if (e.keyCode == 27) { // escape
            closeAllLists();
        } else if (e.keyCode == 13) { // enter
            e.preventDefault();
            if (currentFocus > -1) {
                if (x) {
                    x[currentFocus].click();
                    this.form.submit();
                }
            } else {
                this.form.submit();
            }
        }
    });

    function dropdown(e) {
        var a, b, i, val = this.value;
        console.log("Untrimmed val " + val);
        if (allow_many) {
            current_val = val.split(/,|\|/).slice(-1)[0].trim();
            console.log("Trimmed val " + current_val);
        } else {
            current_val = val;
        }
        closeAllLists();
        currentFocus = -1;
        a = document.createElement("DIV");
        a.setAttribute("id", this.id + "autocomplete-list");
        a.setAttribute("class", "autocomplete-items");
        setAppropriateWidth(a, values);
        this.parentNode.appendChild(a);
        var autocomplete_size = 0;
        for (i = 0; i < values.length; i++) {
            var substring_index = values[i].toUpperCase().indexOf(current_val.toUpperCase());
            if (substring_index > -1 || current_val == "") {
                b = document.createElement("DIV");
                b.innerHTML = values[i].substr(0, substring_index);
                b.innerHTML += "<strong>" + values[i].substr(substring_index, current_val.length) + "</strong>";
                b.innerHTML += values[i].substr(substring_index + current_val.length);
                b.innerHTML += "<input type='hidden' value='" + values[i] + "'>";
                b.addEventListener("click", function(e) {
                    input_field.value = val.substring(0, val.length - current_val.length) + this.getElementsByTagName("input")[0].value;
                    input_field.form.submit();
                    closeAllLists();
                });
                a.appendChild(b);
                autocomplete_size += 1;
                if (autocomplete_size >= 100) {
                    break;
                }
            }
        }
    }

    function addActive(x) {
        if (!x) {
            return false;
        }
        removeActive(x);
        if (currentFocus >= x.length) {
            currentFocus = 0;
        }
        if (currentFocus < 0) {
            currentFocus = (x.length - 1);
        }
        x[currentFocus].classList.add("autocomplete-active");
    }
    function removeActive(x) {
        for (var i = 0; i < x.length; i++) {
            x[i].classList.remove("autocomplete-active");
        }
    }
    function closeAllLists(elmnt) {
        var x = document.getElementsByClassName("autocomplete-items");
        for (var i = 0; i < x.length; i++) {
            if (elmnt != x[i] && elmnt != input_field) {
                x[i].parentNode.removeChild(x[i]);
            }
        }
    }
    document.addEventListener("click", function (e) {
        closeAllLists(e.target);
    });
}

function suggestTableFilters(suggest_items) {
    var itypes = suggest_items["itype"];
    var ctypes = suggest_items["ctype_list"];
    var prjs = suggest_items["prj_list"];
    var hosts = suggest_items["host_list"];
    var tags = suggest_items["tag_list"];
    var signals = suggest_items["signal"];
    autocomplete(document.getElementById("itype"), itypes);
    autocomplete(document.getElementById("ctype_list"), ctypes);
    autocomplete(document.getElementById("prj_list"), prjs);
    autocomplete(document.getElementById("host_list"), hosts);
    autocomplete(document.getElementById("tag_list"), tags, allow_many=true);
    autocomplete(document.getElementById("signal"), signals);
}

function suggestSingleCoreFilters(suggest_items) {
    var ctype = suggest_items["ctype"];
    var prj = suggest_items["prj"];
    var instance = suggest_items["instance"];
    var tags = suggest_items["tags"];
    autocomplete(document.getElementById("ctype"), ctype);
    autocomplete(document.getElementById("prj"), prj);
    autocomplete(document.getElementById("instance"), instance);
    autocomplete(document.getElementById("tags"), tags, allow_many=true);
}

function checkTimeFormatCorrectness() {
    var input_time_string = $(this).val();
    var time_parts = input_time_string.trim().split(" ");
    if (time_parts.length > 2) {
        this.setCustomValidity("Incorrect format");
        this.reportValidity();
        return;
    }
    const correctChars = "0123456789.: ";
    const isCorrectCharacter = (currentChar) => correctChars.includes(currentChar);
    for (var i = 0; i < input_time_string.length; i++) {
        if (!isCorrectCharacter(input_time_string.charAt(i))) {
            this.setCustomValidity(`Every symbol should be one of ${correctChars}`);
            this.reportValidity();
            return;
        }
    }

    var matches = time_parts[0].match(/(\d{4})\.(\d{2})\.(\d{2})/);
    if (matches == null || (time_parts[0].length !== 10)) {
        this.setCustomValidity(`Date format should be 'YYYY.MM.DD'`);
        this.reportValidity();
        return;
    }
    if (time_parts.length === 2) {
        var matches_with_seconds = time_parts[1].match(/(\d{2}):(\d{2}):(\d{2})/);
        var matches_without_seconds = time_parts[1].match(/(\d{2}):(\d{2})/);
        if (
            (matches_with_seconds !== null && time_parts[1].length === 8) ||
            (matches_without_seconds !== null && time_parts[1].length === 5)
        ) {
            this.setCustomValidity("");
            this.reportValidity();
            return;
        }
        else {
            this.setCustomValidity(`Time format should be 'HH:MM:SS' or 'HH:MM'`);
            this.reportValidity();
            return;
        }
    }
    this.setCustomValidity("");
    this.reportValidity();
    return;
}

function setTimeFormatCheck() {
    $("#first_time").keydown(checkTimeFormatCorrectness);
    $("#last_time").keydown(checkTimeFormatCorrectness);
}
