def parse_tokens(s):
    """
    Parse comma-separated tokens from string.

    :return: list of unique sorted tokens.
    """
    if s is None:
        return []

    s = s.replace('\n', '')

    return sorted(list(set([
        token.strip() for token in s.split(',') if token
    ])))


def merge_tokens(first, second):
    """
    :param first: comma-separated tokens string
    :param second: comma-separated tokens string
    :return: merged comma-separated tokens string
    """
    merged_tokens = sorted(list(set(
        parse_tokens(first) + parse_tokens(second)
    )))
    return ",".join([token for token in merged_tokens if token])
