import logging
from search.tools.devops.libs import utils


def get_unique_items(query, column_names, model, limit=None):
    tokens = {column_name: [] for column_name in column_names}
    logging.debug("[get_unique_items] column_names: %s", column_names)
    entities = [getattr(model, column_name) for column_name in column_names]

    query = query.with_entities(*entities)
    if limit is not None:
        query = query.order_by(model.last_time).limit(limit)
    else:
        query = query.all()

    for core in query:
        for column_name in column_names:
            tokens[column_name] += utils.split_non_empty(getattr(core, column_name), ',\n')

    for column_name in column_names:
        tokens[column_name] = [i for i in list(set(tokens[column_name])) if i]

    return tokens
