from infra.cores.app import helpers
from infra.cores.app import strings


def core_details_impl(r_args):
    args = r_args.to_dict()
    core_hash = args.get("core_hash", "")
    itype = args.get("itype", "")

    response = {
        'core_hash': core_hash,
        'itype': itype,
        'first_time': None,
        'last_time': None,
        'last_core_id': None,
        'prj_list': [],
        'tag_list': [],
        'tickets': [],
        'count': 0,
    }

    core_query = helpers.get_core(core_hash, itype)
    if not core_query:
        return response

    for field in response:
        attr = getattr(core_query, field)
        if attr is None:
            continue

        if field in ('prj_list', 'tag_list', 'tickets'):
            attr = strings.parse_tokens(attr)

        response[field] = attr

    return response
