from infra.cores.app import strings
from infra.cores.app import models


def core_info_impl(r_args):
    args = r_args.to_dict()
    core_id = args.get("core_id", -1)

    response = {
        'core_id': core_id,
        'core_hash': None,
        'instance': '',
        'itype': '',
        'ctype': '',
        'prj': '',
        'tags': [],
        'signal': None,
        'sb_build': None,
        'sb_task_run': None,
        'timestamp': None,
        'tickets': [],
        'expire_time': None,
    }

    found_core_info = models.CoreDetails.query.filter(
        models.CoreDetails.core_id == core_id,
    ).first()

    if not found_core_info:
        return response

    for field in response:
        attr = getattr(found_core_info, field)
        if attr is None:
            continue

        if field in ('tags', 'tickets'):
            attr = strings.parse_tokens(attr)

        response[field] = attr

    return response
