from infra.cores.app import filters
from infra.cores.app import strings


def core_list_ids_impl(r_args):
    args = r_args.to_dict()
    itype = args.get("itype", None)
    tags = args.get("tags", None)
    ctype = args.get("ctype", None)
    prj = args.get("prj", None)
    first_time = args.get("first_time", None)
    last_time = args.get("last_time", None)

    response = {
        'ids': [],
    }

    if tags:
        tags = strings.parse_tokens(tags)
    filtered_cores = filters.get_filtered_cores_details(
        itype=itype,
        tags=tags,
        ctype=ctype,
        prj=prj,
        first_time=first_time,
        last_time=last_time,
        columns=('core_id',),
    )

    if filtered_cores is None:
        return response

    for core_detail in filtered_cores:
        response['ids'].append(core_detail.core_id)

    return response
