# coding: utf-8

import logging
import flask as fl

from infra.cores.app import helpers


def submit_core_impl(r_args):
    """
    Process received core, returns code 200 or 400 and json with keys `msg`, `core_id`, `core_hash`, `error`.
    Error = True, core_id = core_hash = None if we can't process core.
    :return: object flask.Response with json with keys `msg`, `core_id`, `core_hash`, `error`.
    """
    json_data = fl.request.get_json()

    # default response is an unknown error
    raw_response = {
        "msg": "Unknown problem, please report to developers",
        "core_id": None,
        "core_hash": None,
        "error": True,
    }

    if json_data is None:
        raw_response["msg"] = "Invalid request. POST body should be JSON",
        return raw_response

    if "parsed_traces" not in json_data:
        raw_response["msg"] = "JSON body should contain a key with `parsed_traces`"
        return raw_response

    try:
        dump_json = json_data.get('dump_json', {})
        additional_text = json_data.get('additional_text', "")
        logging.debug("Got JSON_data %s", json_data)
        logging.debug("Got dump_json %s", dump_json)
        logging.debug("Got additional_text %s", additional_text)
        properties = dump_json.get("properties", {})
        prj = properties.get("INSTANCE_TAG_PRJ", "")

        args = r_args.to_dict()
        args["prj"] = args.get("prj", "") or json_data.get("prj", "") or prj
        args["time"] = args.get("time") or json_data.get("time")
        # 'service' is deprecated
        args["itype"] = (
            args.get("itype", "") or
            args.get("service", "") or
            json_data.get("itype", "") or
            json_data.get("service", "")
        )
        freespace = args.get("freespace", "") or json_data.get("freespace", "")
        if freespace and freespace < 10:
            additional_text += "NO SPACE ON HOST\n"
        coresize = args.get("coresize", "") or json_data.get("coresize", "")
        if coresize == "unknown":
            additional_text += "CORE FILE DELETED\n"
        if coresize.startswith("0"):
            additional_text += "EMPTY CORE\n"
        args["ctype"] = args.get("ctype", "") or json_data.get("ctype", "")
        args["server"] = properties.get("HOSTNAME", "") or args.get("server", "") or json_data.get("server", "")
        args["signal"] = args.get("signal", "") or json_data.get("signal", "")
        args["parse_result"] = args.get("parse_result", "") or json_data.get("parse_result", "")
        args["parse_error"] = args.get("parse_error", "") or json_data.get("parse_error", "")
        args["tags"] = args.get("tags", "") or json_data.get("tags", "")
        args["nanny_service_id"] = args.get("nanny_service_id", "") or json_data.get("nanny_service_id", "")
        args["old_cores"] = args.get("old_cores", False) or json_data.get("old_cores", False)
        old_cores = args["old_cores"]
        if old_cores == u"False":
            args["old_cores"] = False
        elif old_cores == u"True":
            args["old_cores"] = True
        args["staff_logins"] = args.get("staff_logins", "") or json_data.get("staff_logins", "")
        logging.debug("Got args %s", str(args))

        added_core_info = helpers.add_core(json_data['parsed_traces'], args, additional_text)
        raw_response.update(added_core_info)
        raw_response['msg'] = 'Core was successfully submitted'
        raw_response['error'] = False
    except Exception as e:
        logging.exception("Adding core failed: %s", e)
        raw_response["error"] = "Adding core failed, see logs for details for reqid {}: {}".format(
            fl.request.reqid, str(e),
        )

    # helpers.send_message_to_lb(json_data['parsed_traces'], args, additional_text)

    return raw_response
