# -*- coding: utf-8 -*-
import os
import platform
from logging.config import dictConfig


class Config(object):

    DATABASE_CONNECT_OPTIONS = {}
    SQLALCHEMY_DATABASE_URI = ''
    SERVER_PORT = 6060
    BOOTSTRAP_USE_MINIFIED = True
    BOOTSTRAP_SERVE_LOCAL = True

    # store logs into /logs/ folder in production/testing
    # and in local folder for local installations
    _log_path = "/logs/server.log" if os.getenv("NANNY_SERVICE_ID") else "server.log"

    LOG_PATH_BY_PLATFORM = {
        "Linux": _log_path,
    }

    dictConfig({
        "version": 1,
        "formatters": {"default": {'format': '%(asctime)s|%(thread)d|%(levelname)s|%(module)s: %(message)s'}},
        "handlers": {
            "main": {
                "class": "logging.handlers.RotatingFileHandler",
                "filename": LOG_PATH_BY_PLATFORM.get(platform.system(), "server.log"),
                "maxBytes": 1024 ** 3,  # 1Gb
                "backupCount": 4,
                "formatter": "default",
            }
        },
        "root": {"level": "DEBUG", "handlers": ["main"]},
    })
    BASE_DIR = os.getcwd()


class DebugConfig(Config):
    _db_pass = os.getenv("DB_PASS")
    _db_host = os.getenv("DB_HOST")
    _db_user = os.getenv("DB_USER") or "saylars"  # historical funny naming
    _db_port = os.getenv("DB_PORT") or 6432
    _db_name = os.getenv("DB_NAME") or "cores_db"
    SQLALCHEMY_DATABASE_URI = (
        "postgresql://{user}:{password}@{host}:{port}/{db_name}?target_session_attrs=read-write"
    ).format(
        user=_db_user,
        password=_db_pass,
        host=_db_host,
        port=_db_port,
        db_name=_db_name,
    )


default = DebugConfig
