#!/usr/bin/env python
from __future__ import print_function
from __future__ import unicode_literals

import argparse
import datetime
import os
import sys
import re

import ujson
import requests



PATH_EMIT = '/nanny/services/events_migration/emit_new_sync_events/'
NANNY_URL = 'https://nanny.yandex-team.ru'

def _has_policy_coredump(s):
    d = ujson.dumps(s['runtime_attrs']['content'].get('instance_spec', {}))
    return 'COREDUMP' in d


def _process_all_services(session, zk):
    resp = session.get('{}/api/repo/ListSummaries/'.format(NANNY_URL))
    resp.raise_for_status()
    service_count = resp.json()['total']
    req_limit = 200
    req_offset = 0
    output = open("s.txt", "w")
    while req_offset < service_count:
        print(req_offset, service_count, file=sys.stderr)
        response = session.get('{}/v2/services'.format(NANNY_URL), params={'skip': req_offset,
                                                                           'limit': req_limit})
        if not response.ok:
            print('Could not get service descriptions')
            # response.raise_for_status()

        services = response.json()['result']

        for service in services:
            s_id = service['_id']
            if _has_policy_coredump(service):
				print(s_id, '|', service['auth_attrs']['content']['owners']['logins'], file=output)
        req_offset += req_limit

def main():
    sess = requests.Session()
    sess.headers['Authorization'] = 'OAuth {}'.format(os.getenv('NANNY_OAUTH'))
    zk_hosts = os.getenv('ZK_HOSTS')
    zk = None
    if zk_hosts:
        zk = KazooClient(zk_hosts)
        zk.start()
    # _process_services_list(sess, ['yp-test-alonger'], sb_client, zk)
    _process_all_services(sess, zk)


if __name__ == '__main__':
    main()

