#!/usr/bin/env bash

set -xe
set -o pipefail

curl="curl -k"

if [[ "$1" == "testing" ]] ; then
    host_port="https://coredumps-testing.yandex-team.ru"
elif [[ "$1" == "prod" ]] ; then
    host_port="https://coredumps.yandex-team.ru"
elif [[ "$1" == "localhost" ]] ; then
    host_port="http://localhost:20500"
else
    host_port="http://qyp-seek-6.vla.yp-c.yandex.net:20500"
fi

function post_json() {
    url="$1"
    data_name="$2"
    $curl -X POST -H 'Content-Type: application/json' --data-binary "@${data_name}" "${host_port}${url}" | jq .
}

function get() {
    # <url> <check_string> <comma-separated options>
    url="$1"
    check_string="$2"
    $curl "${host_port}${url}" > output.txt
    if ! grep -q "$check_string" output.txt ; then
        echo "Cannot detect '$check_string' in output"
        return 1
    fi
    if echo "$3" | grep -q "print" ; then
        cat output.txt | jq .
    fi

}

core_id=$(post_json "/submit_core?time=1000" "tests/submit_core_1.json" | jq .core_id)
get "/api/core?core_id=$core_id" "$core_id" "print,"

post_json "/submit_core?time=1000" "tests/submit_core_2.json"
post_json "/submit_core?time=1001" "tests/submit_core_1.json"
post_json "/submit_core?invalid_cgi=hack" "tests/submit_core_3.json" > /tmp/output_submit_3.json
core_id="$(jq .core_id /tmp/output_submit_3.json)"
# check timestamp
get "/api/core?core_id=$core_id" "1234567890" "print,"

post_json "/submit_core?" "tests/submit_core_5.json" > /tmp/output_submit_5.json
if ! grep -q "JSON body should contain a key" /tmp/output_submit_5.json ; then
    echo "Failed invalid submission JSON test"
    exit 1
fi

# check empty timestamp: current time should be used
current_time_prefix="$(date +%s | cut -c 1-7)"
post_json "/submit_core" "tests/submit_core_4.json" > /tmp/output_submit_4.json
core_id="$(jq .core_id /tmp/output_submit_4.json)"
# here we can fail if we wrap over 1000-seconds border
# (e.g. when timestamp ended at 999 and it wrapped over 1000 during submission)
get "/api/core?core_id=$core_id" "$current_time_prefix" "print,"

exit 0
get "/background_tick?invocation_time=1" "CONTINUE"
get "/background_tick?invocation_time=0" "CONTINUE"
get "/background_tick" "ERROR"


echo "DUMB TESTS OK"
