import copy

from itertools import chain

from setuptools import setup

from setup_common import packageOnly, packageRecursive, setupArgs, options

setupArgs = copy.deepcopy(setupArgs)

setupArgs.update(
    name='skynet_cqudp_service' + ('-beta' if options.beta else ''),
    packages=list(set(
        chain(
            packageRecursive('util'),
            packageRecursive('library'),
            packageOnly('services.cqudp'),
            packageRecursive('services.cqudp.auth'),
            packageRecursive('services.cqudp.client'),
            packageRecursive('services.cqudp.daemon_client'),
            packageRecursive('services.cqudp.debugtools'),
            packageRecursive('services.cqudp.eggs'),
            packageRecursive('services.cqudp.mocksoul_rpc'),
            packageRecursive('services.cqudp.rpc'),
            packageRecursive('services.cqudp.scripts'),
            packageRecursive('services.cqudp.server'),
            packageRecursive('services.cqudp.transport'),
        )
    )),
    package_data={
        '': ['etc/*.yaml'],
    },
    entry_points={
        'console_scripts': [
            'cqudp = ya.skynet.services.cqudp.main:main',
            'buscheck = ya.skynet.services.cqudp.debugtools.buscheck:main',
            'debug-requests = ya.skynet.services.cqudp.debugtools.debugclient:main',
            'cqudp-stats = ya.skynet.services.cqudp.debugtools.stats:main',
            'cqudp-client = ya.skynet.services.cqudp.client.daemon:main',
            'start-cqudp = ya.skynet.services.cqudp.scripts.start:main',
            'check-cqudp = ya.skynet.services.cqudp.scripts.check:main',
            'stop-cqudp = ya.skynet.services.cqudp.scripts.stop:main',
        ]
    }
)

setup(
    **setupArgs
)
