import copy

from itertools import chain

from setuptools import setup

from setup_common import packageOnly, packageRecursive, setupArgs, options

setupArgs = copy.deepcopy(setupArgs)

packageDir = setupArgs['package_dir'].copy()
packageDir['api'] = '_contrib/api'
setupArgs.update(
    name='skynet_cqudp_thinclient' + ('-beta' if options.beta else ''),
    author='Vsevolod Velichko',
    author_email='torkve@yandex-team.ru',
    description='cqudp standalone thinclient',
    namespace_packages=setupArgs['namespace_packages'] + ['api'],
    package_dir=packageDir,
    packages=list(set(
        chain(
            ('api', 'api.cqueue',),
            packageRecursive('util'),
            packageRecursive('library'),
            packageOnly('services.cqudp'),
            packageOnly('services.cqudp.daemon_client'),
            packageOnly('services.cqudp.rpc'),
            packageOnly('services.cqudp.mocksoul_rpc'),
        )
    )),
    install_requires=[
        'PyYAML',
        'six',
        'msgpack_python==0.2',
        'gevent>=0.13.8',
    ],
    package_data={
        '': ['etc/*.yaml'],
    },
)

setup(
    **setupArgs
)
