from __future__ import absolute_import

from . import compat

compat.patch_modules()

from .utils import singleton, log as root
from ya.skynet.util.config import Config


@singleton
def log():
    return root()


try:
    from ya.skynet.library.config import query
    __overrides = query('skynet.services.cqudp')
    __cgroups_overrides = query('skynet.common.cq_task_cgroups', 'options')
    __containers_overrides = query('skynet.common.cq_task_containers', '')
except:
    log().exception("Cannot load genisys server config: ")
    __overrides = None
    __cgroups_overrides = None
    __containers_overrides = None


cfg = Config(
    'ya.skynet.cqudp', """
server:
  bus_port: 0
  bus_port_msgpack: 10040
  netlibus_port: 10041

  user: skynet

  LogLevel: INFO

  TempDir: '/var/tmp/{userName}'
  TasksTempDir: '/var/tmp'
  Tmpfs: []

  Executers: ['subprocess', 'procman']
  AllowExitContainer: True
  Procman:
    UsePorto: False
  bind_containers: False

  Transport:
    SendOwnIp: False

  Auth:
    Syslog: true

    KeyFiles:
     - '.*public$'
     - '.*pub$'
     - 'authorized_keys'

    UserKeyDirs:
     - '{userHome}/.ssh'

    CommonKeyDirs:
     - '{installRoot}/etc/auth'
     - '{installRoot}/kqueue/authkeys'  # Backward compatibility

    # Path to files with certificates contents
    CertificateAuthorityFiles: []
    # Strings with certificates contents
    CertificateAuthorityData: []
    # Path to file with key revocation list
    CertificateKRLFile: null
    # Path to file with server admins list
    CertificateServerAdminsFile: null

client:
  Auth:
    KeyFiles:
     - 'id_rsa'
     - 'id_dsa'

    UserKeyDirs:
     - '{userHome}/.ssh'

    CommonKeyDirs:
     - '{installRoot}/etc/auth'
     - '{installRoot}/kqueue/authkeys'  # Backward compatibility

  StopMessage:
    Attempts: 2
    Interval: 0.1

  LogLevel: INFO

  Multipart: False
  MultipartBandwidth: 1000000

  AllowUnsafeUnpickle: True
  ConfirmRpcDelivery: False
  ForwardSshAgent: False
  SessionTimeout: null
  MinOrphanTimeout: 600
  RetryTimeout: 30

  Heartbeats:
    HostsDenominator: 500.0
    MinimalPeriod: 1
    OrphanTimeoutMultiplier: 3.0

  Transport:
    Aggregate: True
    Pipeline: True
    Msgpack: True
    Netlibus: True
    EggInMsgpack: True
    SendOwnIp: False
    SpecialPortRange: [10045, 10049]

thinclient:
  LogLevel: INFO
  RpcPath: '{TempDir}/client.sock'
  Enabled: false

transport:
  netlibus:
    Bandwidth: 0
    """,
    searchPackages='ya.skynet.services.cqudp',
    overrides=__overrides,
)

cgroups_cfg = Config(
    'ya.skynet.cgroups', """
options:
    path: Null
    tasks: {}
    """,
    searchPackages='ya.skynet.services.cqudp',
    overrides=__cgroups_overrides,
)

containers_cfg = Config(
    'ya.skynet.cq_containers', """
containers:
    cqudp-tasks-default:
        options:
            memory_limit: 2G
users:
    ALL: cqudp-tasks-default
    """,
    searchPackages='ya.skynet.services.cqudp',
    overrides=__containers_overrides,
)
