from __future__ import absolute_import

from ..exceptions import CQueueExecutionError, CQueueError, CQueueRuntimeError
from ..utils import monotime


class RHandle(object):
    def __init__(self, session, results_queue):
        self._results = results_queue
        self._session = session

    def poll(self, timeout=None):
        if self._results:
            while self._results:
                yield self._pop_and_unwrap()
            return

        while timeout is None or timeout >= 0:
            start = monotime()

            if self._results.wait_event(min(timeout, 1) if timeout is not None else 1):
                if self._results:
                    while self._results:
                        yield self._pop_and_unwrap()

                return

            if timeout is not None:
                timeout -= monotime() - start

    def wait(self, timeout=None):
        start_time = monotime()

        while timeout is None or monotime() - start_time <= timeout:
            for r in self.poll(timeout=min(timeout, 1) if timeout is not None else 1):
                yield r

            if self._session.is_empty():
                return

    def _pop_and_unwrap(self):
        host, idx, res, err = self._results.pop()
        return host, idx, res, _cqueue_unwrap(err)


# TODO (okats): cqueue-related Exception wrapping/unwrapping should take place in the interface classes, not here.
def _cqueue_unwrap(err):
    if isinstance(err, CQueueExecutionError):
        # Unwrap execution exception
        return getattr(err, 'error')
    elif err is not None and not isinstance(err, CQueueError):
        # Wrap accidentally not wrapped internal exceptions
        return CQueueRuntimeError('Internal error: {}'.format(err))
    return err
