from __future__ import absolute_import

import six
import time
import hashlib

from ya.skynet.util.sys.user import getUserName

from ..utils import genuuid, fqdn
from .. import cfg


# backward compatibility
class Task(object):
    def __init__(self, runnable, options, task_type='task', acc_user=None, uuid=None):
        self.type = task_type
        self.uuid = uuid or genuuid()

        self.data = runnable

        self.ctime = time.time()
        self.acc_user = acc_user or getUserName()
        self.acc_host = fqdn()

        self.options = options
        self.params = {}

        self.signs = []

    def get(self, item, default=None):
        try:
            return getattr(self, item)
        except AttributeError:
            return default

    def __getitem__(self, item):
        try:
            return getattr(self, item)
        except AttributeError:
            raise KeyError(item)

    @property
    def hash(self):
        md5 = hashlib.md5(self.data)
        md5.update(self.uuid)
        md5.update(self.acc_user)
        md5.update(self.acc_host)
        md5.update(str(self.ctime))

        return md5.digest()


def task(runnable, options, task_type='task', acc_user=None, uuid=None):
    return {
        'type': task_type,
        'uuid': uuid or genuuid(),

        'data': runnable,

        'ctime': time.time(),
        'acc_user': acc_user or getUserName(),
        'acc_host': fqdn(),

        'options': options,
        'params': {},

        'signs': [],
    }


def task_hash(task):
    md5 = hashlib.md5(task['data'])
    md5.update(six.b(task['uuid']))
    md5.update(six.b(task['acc_user']))
    md5.update(six.b(task['acc_host']))
    md5.update(six.b(str(task['ctime'])))

    return md5.digest()


def task_options(runnable):
    return {
        'user': runnable.osUser if getattr(runnable, 'osUser', None) is not None else getUserName(),
        'forward_agent': getattr(runnable, 'forwardSshAgent', cfg.client.ForwardSshAgent),
        # Limits overall execution time, after which task is considered failed
        'session_timeout': getattr(runnable, 'sessionTimeout', cfg.client.SessionTimeout),
    }
