from __future__ import absolute_import

import os
import sys

from ya.skynet.services.cqudp import msgpackutils as msgpack

from .collect import collect_modules  # noqa
from .retrieve import get_in_memory_source  # noqa
from .write import (  # noqa
                    package_egg,  # noqa
                    check_main,  # noqa
                    write_module,  # noqa
                    write_package,  # noqa
)
from .compiled_file import InMemoryCompiledFile


def create_egg(modules_list=None, log=None):
    modules = collect_modules(modules_list=modules_list, log=log)
    if not modules:
        return None

    return package_egg(modules, log=log)


def make_arcadia_binary(runnable_str):
    from api.copier import Copier

    copier = Copier()
    torrentid = copier.create([os.path.basename(sys.executable)], cwd=os.path.dirname(sys.executable)).resid()
    torrentsize = os.stat(sys.executable).st_size

    code = None
    with InMemoryCompiledFile(
        name='__main__',
        original_source=get_in_memory_source('__main__', __import__('__main__'))
    ) as main_file:
        for ext, item in main_file:
            if ext == '.pyc':
                code = item

    data = {
        'object': runnable_str,
        'exec_custom_main': code,
        'resource_id': torrentid,
        'entry_point': 'ya.skynet.services.cqudp.server.binaryprocess:main',
        'size': torrentsize,
    }
    return data


def serialize(runnable_str, modules=None, arcadia_binary=False, log=None):
    if arcadia_binary:
        data = make_arcadia_binary(runnable_str)
    else:
        egg = create_egg(modules_list=modules, log=log)
        data = (runnable_str, egg)

    return msgpack.dumps(data)
