from __future__ import absolute_import

import os
import imp
import time
import types
import struct
import marshal


class InMemoryCompiledFile(object):
    """
    Class to get source and compiled version of passed python module file or its content.
    """
    def __init__(self, name=None, original_file=None, original_source=None, original_code=None):
        self.original_file = original_file
        self.modname = name
        self.original_source = original_source
        self.original_code = original_code

    def __iter__(self):
        if self.original_source:
            yield ('.py', self.original_source)
        if self.original_code:
            if isinstance(self.original_code, types.CodeType):
                pyc = imp.get_magic() + struct.pack('<l', int(time.time())) + marshal.dumps(self.original_code)
            else:
                pyc = self.original_code
            yield ('.pyc', pyc)

    def _fill_files(self):
        if self.original_file is not None and os.path.isfile(self.original_file):
            split_ext = os.path.splitext(self.original_file)

            if split_ext[1] == '.py':
                self.original_source = open(self.original_file, 'r').read()
            elif split_ext[1] == '.pyc':
                self.original_code = open(self.original_file, 'rb').read()

        if self.original_source is not None and self.original_code is None:
            filename = self.original_file and os.path.abspath(self.original_file) or (self.modname + '.py')
            self.original_code = compile(self.original_source, filename, 'exec', 0, 1)

    def __enter__(self):
        self._fill_files()
        return self

    def __exit__(self, *_):
        pass
