from __future__ import absolute_import
import six
import msgpack


MSGPACK_HAS_BIN = msgpack.version[0] > 0 or msgpack.version[1] > 3


def _dump_obj(obj):
    # FIXME move serialization to class itself
    if type(obj).__name__ == 'Envelope':
        return {
            '__msgpack_cls__': 'Envelope',
            'msgs': obj.msgs,
            'tree': obj.tree,
            'path': obj.path,
            'hostid': obj.hostid,
            'data': obj.data,
            'tree_data': obj.tree_data,
            'aggr': getattr(obj, 'aggr', False),
        }
    raise TypeError('{!r} is not sendable'.format(obj))


def _load_obj(dct):
    if six.PY3:
        dct = {k.decode('ascii')
               if isinstance(k, six.binary_type) else k: v
               for k, v in six.iteritems(dct)}
    if '__msgpack_cls__' not in dct:
        return dct
    # FIXME move deserialization to class itself
    if dct['__msgpack_cls__'] == 'Envelope':
        from .transport.envelope import Envelope
        dct.pop('__msgpack_cls__')
        res = Envelope(**dct)
        res.msg = res.msgs[0]  # FIXME (torkve) drop env.msg or use protocol._convert_to_old
        return res
    return dct
    # FIXME (torkve) msgpack 0.2.0 segfaults on exception here, update needed
    # raise ValueError("{} is unknown class".format(dct['__msgpack_cls']))


def dumps(msg, **kwargs):
    args = {
        'default': _dump_obj,
    }
    if MSGPACK_HAS_BIN and six.PY3:
        args.update(use_bin_type=True, encoding='utf-8')

    args.update(kwargs)
    return msgpack.dumps(msg, **args)


def loads(msg, **kwargs):
    args = {
        'use_list': False,
        'object_hook': _load_obj,
    }
    if MSGPACK_HAS_BIN and six.PY3:
        args['encoding'] = 'utf-8'
    args.update(kwargs)
    return msgpack.loads(msg, **args)


packb = dumps
unpackb = loads


def Unpacker(**kwargs):
    args = {
        'object_hook': _load_obj,
        'use_list': False,
    }
    if MSGPACK_HAS_BIN and six.PY3:
        args['encoding'] = 'utf-8'

    args.update(kwargs)

    return msgpack.Unpacker(**args)
