import os
import ctypes
from ctypes.util import find_library


__all__ = ['Cgroup', 'Ipc', 'Network', 'Mount', 'Pid', 'User', 'Uts', 'move_to_ns']

libc = ctypes.CDLL(find_library("c"))

Fs = CLONE_FS = 0x00000200
Cgroup = CLONE_NEWCGROUP = 0x02000000
Ipc = CLONE_NEWIPC = 0x08000000
Network = CLONE_NEWNET = 0x40000000
Mount = CLONE_NEWNS = 0x00020000
Pid = CLONE_NEWPID = 0x20000000
User = CLONE_NEWUSER = 0x10000000
Uts = CLONE_NEWUTS = 0x04000000

try:
    setns = libc.setns
    setns.argtypes = [ctypes.c_int, ctypes.c_int]
    setns.restype = ctypes.c_int
except (AttributeError, KeyError):
    def setns(fd, nstype):
        raise RuntimeError("setns is not supported by this libc, sorry")

try:
    _unshare = libc.unshare
    _unshare.argtypes = [ctypes.c_int]
    _unshare.restype = ctypes.c_int
except (AttributeError, KeyError):
    def _unshare(mode):
        raise RuntimeError("unshare is not supported by this libc, sorry")


def move_to_ns(fileobj, mode):
    if not isinstance(fileobj, int):
        fileobj = fileobj.fileno()

    ret = setns(fileobj, mode)
    if ret != 0:
        errno = ctypes.get_errno()
        raise OSError(errno, os.strerror(errno))


def unshare_ns(mode):
    ret = _unshare(mode)
    if ret != 0:
        errno = ctypes.get_errno()
        raise OSError(errno, os.strerror(errno))
