"""
Remote logging facilities for cqudp
"""

import six

from ya.skynet.util import logging

from . import gRPCDispatcher
from ..utils import genuuid


class CQRemoteLogHandler(logging.Handler):
    """
    This handler could be installed in context of remote object
    """

    def __init__(self, level=logging.NOTSET):
        logging.Handler.__init__(self, level)  # Not using super() since it's still classobj, not type
        self._uuid = genuuid()
        self._data_index = 0

    def emit(self, record):
        idx, self._data_index = self._data_index, self._data_index + 1
        ei = record.exc_info
        if ei:
            self.format(record)  # just to make sure 'exc_text' is filled
            record.exc_info = None  # prevent from failing on un(un)picklable exceptions

        data = {k: v for k, v in six.iteritems(record.__dict__) if not k.startswith('__')}

        data['msg'] = record.getMessage()
        data['args'] = None

        record.exc_info = ei  # restore for next Handler

        data['__log_uuid'] = self._uuid
        data['__log_index'] = idx
        gRPCDispatcher().send('log', self._uuid, data)
