import os
import time


def main(args=None):
    from ya.skynet.library.config import query
    from ya.skynet.util.pickle import loads
    from ya.skynet.util.sys.gettime import monoTime
    from ya.skynet.util.sys.user import getUserName

    config = query('skynet.services.cqudp', 'config')['server']

    tempdir = config['TempDir']
    user = os.getenv('SKYNET_CQUDP_USER', config['user'])
    if os.getuid() != 0:
        user = getUserName()
    tempdir = os.path.join(tempdir.format(userName=user), 'cqudp')

    t = monoTime()
    ut = time.time()

    f = os.path.join(tempdir, 'state', 'cqudp.state')
    state = loads(open(f, 'rb').read())

    if 'unix_timestamp' in state:
        if ut - state['unix_timestamp'] > 600:
            raise SystemExit(2)
    elif t - state['timestamp'] > 600 or t - state['timestamp'] < 0:
        raise SystemExit(3)

    status_len = len([config[p] for p in ('bus_port', 'bus_port_msgpack', 'netlibus_port') if config[p] != 0])
    raise SystemExit(
        int(not(  # map bool -> exitcode
            len(state['status']) == status_len
            and all(status['running'] for status in state['status'])
        ))
    )


if __name__ == '__main__':
    main()
