import os
import sys
import socket
import signal
import errno


def main():
    for pid in sys.argv[1:]:
        os.kill(int(pid), signal.SIGINT)

    if os.uname()[0].lower() == 'linux':
        s = socket.socket(socket.AF_UNIX)
        s.settimeout(15.0)
        try:
            s.connect('\0rc-cqudp')
        except EnvironmentError as e:
            if e.errno != errno.ECONNREFUSED:
                raise
        else:
            s.sendall('shutdown\n')
            res = s.recv(64)
            s.close()
            assert res == 'OK', res
