#!/home/torkve/bin/skypy/skynet/python/bin/python

import os
import socket

from ya.skynet.services.cqudp.utils import log
from ya.skynet.services.cqudp.server.processhandle import ProcessHandle


def main():
    try:
        taskid = os.environ['CQUDP_TASKID']
        loglevel = os.environ['CQUDP_LOGLEVEL'] or None
        tempdir = os.environ['CQUDP_TEMPDIR']
        parent_fd = int(os.environ['CQUDP_PARENTFD'])
        parent_family = int(os.environ['CQUDP_PARENTFAMILY'])
        parent_type = int(os.environ['CQUDP_PARENTTYPE'])

        sock = socket.fromfd(parent_fd, parent_family, parent_type)

        process = ProcessHandle(taskid, None, tempdir, loglevel)
        process.run_with_sock(sock)
    except Exception:
        log().exception("exec failed")


if __name__ == '__main__':
    main()
